#ifndef	   FILE_IO_H_INCLUDED
#define	   FILE_IO_H_INCLUDED

// Author:		H. Shimora
// Created:		Dec  6 2005
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Dec  6 2005    base version.
//
//

#include  "fd_io.h"
#include  "abstract_io.h"
#include  "path.h"

#include  <cstdlib>
#include  <fcntl.h> // for open()


class  File_IO : public FD_IO
{
public:
	File_IO( const Path &  path ,  bool  for_read ,  bool  for_write ,
		 bool  force = false )
		: FD_IO( -1 )
	{
		int	flags = 0;

		if ( for_read && for_write )
		{
			flags |= O_RDWR;
		}
		else if ( for_read )
		{
			flags |= O_RDONLY;
		}
		else if ( for_write )
		{
			flags |= (O_WRONLY & O_CREAT & O_TRUNC);
		}


		int	fd;
		if ( (fd = ::open( path.native_string().c_str() ,
				   flags )) == -1 )
		{
			std::perror( "open" );
			std::cerr << "Can't open file \""
				  << path.native_string() << "\"."
				  << std::endl;

			if ( ! force )
			{
				::exit( 1 );
			}
		}

		this -> FD_IO::initialize_fd( fd );
	}

	virtual	~File_IO()
	{
	}
};


#endif	/* FILE_IO_H_INCLUDED */
