#ifndef	   COMPAT_STRINGSTREAMBUF_H_INCLUDED
#define	   COMPAT_STRINGSTREAMBUF_H_INCLUDED

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "streambuf_extension.h"
#include  <string>
#include  <cstdio>


class  compat_stringstreambuf : public streambuf_extension
{
private:
	 // not allowed.
	 compat_stringstreambuf( const compat_stringstreambuf & );

	 // not allowed.
	 compat_stringstreambuf &
		     operator= ( const compat_stringstreambuf & );


private:
	char		buffer[BUFSIZ];
	std::string	io_str;

	void	initialize_buffer()
	{
		// XXX: no buffer
		this -> std::streambuf::setg( buffer , buffer , buffer );
	}


public:
	compat_stringstreambuf()
		: io_str()
	{
		this -> initialize_buffer();
	}

	compat_stringstreambuf( const std::string &  input )
		: io_str( input )
	{
		this -> initialize_buffer();
	}


	int  overflow( int  ch = EOF )
	{
		if ( ch == EOF )
		{
			return( EOF );
		}

		this -> io_str.append( 1 , static_cast<unsigned char>(ch) );

		return( ch );
	}

	int  underflow()
	{
		int	ch = this -> uflow();

		this -> pbackfail( ch );

		return( ch );
	}

	int  uflow()
	{
		if ( this -> input_buffer_current()
		     >= this -> buffer + sizeof(this -> buffer) )
		{
			this -> std::streambuf::setg
				( this -> input_buffer_begin() ,
				  this -> input_buffer_begin() ,
				  this -> input_buffer_begin() );
		}

		if ( ! this -> io_str.empty() )
		{
			int	ch = io_str[0];

			*(this -> input_buffer_current())
			    = static_cast<unsigned char>(ch);

			this -> io_str.erase( this -> io_str.begin() );

			this -> std::streambuf::setg
				( this -> input_buffer_begin() ,
				  this -> input_buffer_current() ,
				  this -> input_buffer_current() + 1 );
			this -> input_buffer_move_current( 1 );

			return( static_cast<unsigned char>(ch) );
		}
		else
		{
			return( EOF );
		}
	}

	int	pbackfail( int  ch )
	{
		if ( ch == EOF )
		{
			return( ch );
		}

		if ( this -> input_buffer_current()
		     > this -> input_buffer_begin() )
		{
			this -> input_buffer_move_current( -1 );

			return( ch );
		}
		else
		{
			return( EOF );
		}
	}

	const std::string &	str() const
	{
		compat_stringstreambuf *
			    t = const_cast<compat_stringstreambuf *>( this );

		{
			int	n = this -> input_buffer_remain();

			t -> io_str.insert( 0 ,
					    this -> input_buffer_current() ,
					    n );

			t -> input_buffer_move_current( n );
		}

		{
			int	n = this -> output_buffer_remain();

			t -> io_str.append( this -> output_buffer_current() ,
					    n );

			t -> output_buffer_move_current( n );
		}

		return( this -> io_str );
	}

	void	clear()
	{
		this -> input_buffer_move_current
			( this -> input_buffer_remain() );

		this -> output_buffer_move_current
			( this -> output_buffer_remain() );

		this -> io_str = "";
	}
};


#endif	/* COMPAT_STRINGSTREAMBUF_H_INCLUDED */
