#ifndef	   COMPAT_STRINGSTREAM_H_INCLUDED
#define	   COMPAT_STRINGSTREAM_H_INCLUDED

#include  "compat_stringstreambuf.h"
#include  <iostream>

class  compat_stringstream : public std::iostream
{
protected:
	compat_stringstreambuf	buf;

public:
		compat_stringstream()
			 : std::iostream( static_cast<std::streambuf *>(0) ) ,
			   buf()
		{
			 this -> std::ios::init( &buf );
		}

		compat_stringstream( const std::string &  input )
			 : std::iostream( static_cast<std::streambuf *>(0) ) ,
			   buf( input )
		{
			 this -> std::ios::init( &buf );
		}

	const std::string &  str() const { return( buf.str() ); }
	void  clear()			 { buf.clear(); }
};

class  compat_istringstream : public std::istream
{
protected:
	compat_stringstreambuf	buf;

public:
		compat_istringstream()
			 : std::istream( static_cast<std::streambuf *>(0) ) ,
			   buf()
		{
			 this -> std::ios::init( &buf );
		}

		compat_istringstream( const std::string &  input )
			 : std::istream( static_cast<std::streambuf *>(0) ) ,
			   buf( input )
		{
			 this -> std::ios::init( &buf );
		}

	~compat_istringstream() {}

	const std::string &  str() const { return( buf.str() ); }
	void  clear()			 { buf.clear(); }
};

class  compat_ostringstream : public std::ostream
{
protected:
	compat_stringstreambuf	buf;

public:
		compat_ostringstream()
			 : std::ostream( static_cast<std::streambuf *>(0) ) ,
			   buf()
		{
			 this -> std::ios::init( &buf );
		}

		compat_ostringstream( const std::string &  input )
			 : std::ostream( static_cast<std::streambuf *>(0) ) ,
			   buf( input )
		{
			 this -> std::ios::init( &buf );
		}

	const std::string &  str() const { return( buf.str() ); }
	void  clear()			 { buf.clear(); }
};


#endif	/* COMPAT_STRINGSTREAM_H_INCLUDED */
