#include  "option_analyzer.h"
#include  <iostream>
#include  <string>
#include  <vector>
#include  <cstdio>

//
// Option_Analyzer
//
Option_Analyzer::Option_Analyzer()
	: short_option_map() , long_option_map() ,
	  valid( true ) ,
	  more_options( true ) ,
	  argv_0() ,
	  argv_original() ,
	  rest_opt()
{
}

Option_Analyzer::~Option_Analyzer()
{
}

void   Option_Analyzer::usage( std::ostream * ) const
{
	// override
}

bool   Option_Analyzer::analyze( int  argc ,  const char *const *const  argv )
{
	if ( argc <= 0 )
	{
		this -> valid = false;

		return( false );
	}


	std::vector<std::string>	vec_argv;

	for ( int  indx = 0  ;  indx < argc  ;  indx ++ )
	{
		vec_argv.push_back( argv[indx] );
	}

	return( this -> analyze( vec_argv ) );
}


bool   Option_Analyzer::analyze( const std::vector<std::string> &  argv )
{
	if ( argv.empty() )
	{
		this -> valid = false;

		return( false );
	}

	for ( size_t  indx = 0  ;  indx < argv.size()  ;  indx ++ )
	{
		argv_original.push_back( argv[indx] );
	}


	argv_0 = argv[0];

	for ( size_t  indx = 1  ;  indx < argv.size()  ;  indx ++ )
	{
		const std::string	arg( argv[indx] );

		if ( ! this -> more_options )
		{
			rest_opt.push_back( arg );
		}
		else if ( long_option_map.find( arg )
			  != long_option_map.end() )
		{
			std::vector<std::string>	rest_args;

			for ( size_t  i = indx + 1  ;
			      i < argv.size()  ;  i ++ )
			{
				rest_args.push_back( argv[i] );
			}

			int	used_args
				= (*long_option_map.find( arg )).second
						    -> execute( rest_args );
			if ( used_args < 0 )
			{
				this -> valid = false;
				return( false );
			}

			std::string	error_message;
			if ( (*long_option_map.find( arg )).second
					-> check( &error_message ) == false )
			{
				if ( error_message.length() != 0 )
				{
					std::cerr << error_message
						  << std::endl;
				}

				this -> valid = false;
				return( false );
			}

			indx += used_args;
		}
		else if ( arg.size() >= 1 && arg[0] == '-' )
		{
			if ( arg.size() == 1 )
			{
				std::cerr << "Unknown option \""
					  << arg << "\"" << std::endl;

				this -> valid = false;
				return( false );
			}

			for ( size_t  s = 1  ;  s < arg.size()  ;  s ++ )
			{
				std::vector<std::string>	rest_args;

				for ( size_t  i = indx + 1  ;
				      i < argv.size()  ;  i ++ )
				{
					rest_args.push_back( argv[i] );
				}

				if ( short_option_map.find( arg[s] )
					!= short_option_map.end() )
				{
					int	used_args
					 = (*short_option_map.find( arg[s] ))
					   .second -> execute( rest_args );

					if ( used_args < 0 )
					{
						this -> valid = false;
						return( false );
					}

					std::string	error_message;
					if ( (*short_option_map.find( arg[s] ))
					     .second -> check( &error_message )
					     == false )
					{
						this -> valid = false;
						if ( error_message.length()
						     != 0 )
						{
							std::cerr
							  << error_message
							  << std::endl;
						}

						return( false );
					}

					indx += used_args;
				}
				else
				{
					std::cerr << "Unknown option \""
						  << arg[s] << "\""
						  << std::endl;

					this -> valid = false;
					return( false );
				}
			}
		}
		else
		{
			std::vector<std::string>	rest_args;

			for ( size_t  i = indx  ;  i < argv.size()  ;  i ++ )
			{
				rest_args.push_back( argv[i] );
			}


			int	used_args
				  = this -> analyze_non_option( rest_args );

			if ( used_args < 0 )
			{
				this -> valid = false;
				return( false );
			}

			if ( used_args == 0 )
			{
				rest_opt.push_back( arg );
			}
			else
			{
				indx += (used_args - 1);
			}
		}
	}


	this -> after_analyze_hook();


	if ( ! this -> check() )
	{
		this -> valid = false;

		return( false );
	}

	return( true );
}

const std::string &  Option_Analyzer::program_name() const
{
	return( argv_0 );
}

const std::vector<std::string> &  Option_Analyzer::argv() const
{
	return( argv_original );
}

std::vector<std::string> &  Option_Analyzer::rest()
{
	return( rest_opt );
}

const std::vector<std::string> &  Option_Analyzer::rest_options() const
{
	return( rest_opt );
}

void   Option_Analyzer::finish_analyze()
{
	this -> more_options = true;
}

int    Option_Analyzer::analyze_non_option( const std::vector<std::string> & )
{
	// override
	return( 0 );
}

void   Option_Analyzer::after_analyze_hook()
{
	// override
}

bool   Option_Analyzer::check() const
{
	// override
	return( true );
}

Option_Analyzer::operator  bool() const
{
	return( valid );
}


//
// Add Option
//
void   Option_Analyzer::add_short_option
			( int  short_option ,
			  const ref_count_ptr<const Option_Descriptor> & opt )
{
	if ( short_option == EOF )
	{
		return;
	}

	short_option_map[short_option] = opt;
}

void   Option_Analyzer::add_long_option
			( const std::string &  long_option ,
			  const ref_count_ptr<const Option_Descriptor> & opt )
{
	if ( long_option == "" )
	{
		return;
	}

	long_option_map[long_option] = opt;
}


void   Option_Analyzer::add_option
			( int  short_option ,
			  const std::string &  long_option ,
			  const ref_count_ptr<const Option_Descriptor> &  opt )
{
	this -> add_short_option( short_option , opt );
	this -> add_long_option ( long_option  , opt );
}




//
// Flag On
//
void   Option_Analyzer::add_short_option_flag_on( int  short_option ,
						  bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_On_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_long_option_flag_on
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				  new Flag_On_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_option_flag_on( int  short_option ,
					    const std::string &  long_option ,
					    bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_On_Option_Descriptor( flag ) );
}


//
// Flag Off
//
void   Option_Analyzer::add_short_option_flag_off( int  short_option ,
						   bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_Off_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_long_option_flag_off
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				 new Flag_Off_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_option_flag_off( int  short_option ,
					     const std::string &  long_option ,
					     bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_Off_Option_Descriptor( flag ) );
}


//
// Flag Toggle
//
void   Option_Analyzer::add_short_option_flag_toggle( int  short_option ,
						      bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_Toggle_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_long_option_flag_toggle
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				 new Flag_Toggle_Option_Descriptor( flag ) );
}

void   Option_Analyzer::add_option_flag_toggle
					( int  short_option ,
					  const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_Toggle_Option_Descriptor( flag ) );
}


//
// Integer
//
void   Option_Analyzer::add_short_option_integer( int  short_option ,
						  int *  i )
{
	this -> add_short_option( short_option ,
				  new Integer_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_long_option_integer
					( const std::string &  long_option ,
					  int *  i )
{
	this -> add_long_option( long_option ,
				 new Integer_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_option_integer( int  short_option ,
					    const std::string &  long_option ,
					    int *  i )
{
	this -> add_option( short_option , long_option ,
			    new Integer_Option_Descriptor( i ) );
}


//
// Unsigned Long
//
void   Option_Analyzer::add_short_option_unsigned_long( int  short_option ,
							unsigned long *  i )
{
	this -> add_short_option( short_option ,
				  new Unsigned_Long_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_long_option_unsigned_long
					( const std::string &  long_option ,
					  unsigned long *  i )
{
	this -> add_long_option( long_option ,
				 new Unsigned_Long_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_option_unsigned_long
					( int  short_option ,
					  const std::string &  long_option ,
					  unsigned long *  i )
{
	this -> add_option( short_option , long_option ,
			    new Unsigned_Long_Option_Descriptor( i ) );
}

//
// Long Integer
//
void   Option_Analyzer::add_short_option_long_integer( int  short_option ,
						       long *  i )
{
	this -> add_short_option( short_option ,
				  new Long_Integer_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_long_option_long_integer
					( const std::string &  long_option ,
					  long *  i )
{
	this -> add_long_option( long_option ,
				 new Long_Integer_Option_Descriptor( i ) );
}

void   Option_Analyzer::add_option_long_integer
					( int  short_option ,
					  const std::string &  long_option ,
					  long *  i )
{
	this -> add_option( short_option , long_option ,
			    new Long_Integer_Option_Descriptor( i ) );
}


//
// Float
//
void   Option_Analyzer::add_short_option_float( int  short_option ,
						double *  d )
{
	this -> add_short_option( short_option ,
				  new Float_Option_Descriptor( d ) );
}

void   Option_Analyzer::add_long_option_float
					( const std::string &  long_option ,
					  double *  d )
{
	this -> add_long_option( long_option ,
				 new Float_Option_Descriptor( d ) );
}

void   Option_Analyzer::add_option_float( int  short_option ,
					  const std::string &  long_option ,
					  double *  d )
{
	this -> add_option( short_option , long_option ,
			    new Float_Option_Descriptor( d ) );
}


//
// String
//
void   Option_Analyzer::add_short_option_string( int  short_option ,
						 std::string *  str )
{
	this -> add_short_option( short_option ,
				  new String_Option_Descriptor( str ) );
}

void   Option_Analyzer::add_long_option_string
					( const std::string &  long_option ,
					   std::string *  str )
{
	this -> add_long_option( long_option ,
				 new String_Option_Descriptor( str ) );
}

void   Option_Analyzer::add_option_string( int  short_option ,
					   const std::string &  long_option ,
					   std::string *  str )
{
	this -> add_option( short_option , long_option ,
			    new String_Option_Descriptor( str ) );
}


//
// Port Number
//
void   Option_Analyzer::add_short_option_port_number( int  short_option ,
						      port_number_t *  p )
{
	this -> add_short_option( short_option ,
				  new Port_Number_Option_Descriptor( p ) );
}

void   Option_Analyzer::add_long_option_port_number
					( const std::string &  long_option ,
					  port_number_t *  p )
{
	this -> add_long_option( long_option ,
				 new Port_Number_Option_Descriptor( p ) );
}

void   Option_Analyzer::add_option_port_number
					( int  short_option ,
					  const std::string &  long_option ,
					  port_number_t *  p )
{
	this -> add_option( short_option , long_option ,
			    new Port_Number_Option_Descriptor( p ) );
}


//
// Path
//
void   Option_Analyzer::add_short_option_path( int  short_option ,
					       Path *  p )
{
	this -> add_short_option( short_option ,
				  new Path_Option_Descriptor( p ) );
}

void   Option_Analyzer::add_long_option_path
					( const std::string &  long_option ,
					  Path *  p )
{
	this -> add_long_option( long_option ,
				 new Path_Option_Descriptor( p ) );
}

void   Option_Analyzer::add_option_path( int  short_option ,
					  const std::string &  long_option ,
					  Path *  p )
{
	this -> add_option( short_option , long_option ,
			    new Path_Option_Descriptor( p ) );
}


//
// Raw Arguments
//
void   Option_Analyzer::add_short_option_raw_arguments
					( int  short_option ,
					  std::vector<std::string> *  a )
{
	this -> add_short_option( short_option ,
				  new Raw_Arguments_Descriptor( a ) );
}

void   Option_Analyzer::add_long_option_raw_arguments
					( const std::string &  long_option ,
					  std::vector<std::string> *  a )
{
	this -> add_long_option( long_option ,
				 new Raw_Arguments_Descriptor( a ) );
}

void   Option_Analyzer::add_option_raw_arguments
					( int  short_option ,
					  const std::string &  long_option ,
					  std::vector<std::string> *  a )
{
	this -> add_option( short_option , long_option ,
			    new Raw_Arguments_Descriptor( a ) );
}


//
// Option_Analyzer Option
//
void   Option_Analyzer::add_short_option_option_analyzer
			( int  short_option ,
			  Option_Analyzer *  opt ,
			  const std::string &  separator )
{
	this -> add_short_option( short_option ,
				 new Option_Analyzer_Option_Descriptor
				     ( opt , separator ) );
}

void   Option_Analyzer::add_long_option_option_analyzer
			( const std::string &  long_option ,
			  Option_Analyzer *  opt ,
			  const std::string &  separator )
{
	this -> add_long_option( long_option ,
				 new Option_Analyzer_Option_Descriptor
				     ( opt , separator ) );
}

void   Option_Analyzer::add_option_option_analyzer
			( int  short_option ,
			  const std::string &  long_option ,
			  Option_Analyzer *  opt ,
			  const std::string &  separator )
{
	this -> add_option( short_option ,  long_option ,
			    new Option_Analyzer_Option_Descriptor
				( opt , separator ) );
}
