#ifndef	   REF_COUNT_ARRAY_PTR_H_INCLUDED
#define	   REF_COUNT_ARRAY_PTR_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr 28 2000
// Version:		0.30

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.10  Dec 28 1998    base version.
//
// version 0.20  Dec 29 1998    separate counter and pointer to entity.
//                              memory allocation reduced.
//
// version 0.30  Apr 28 2000    enable different type substitution.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif


template<typename T>
class  ref_count_array_ptr
{
private:
	template<typename U>
	friend class ref_count_array_ptr;

	typedef  unsigned int  REF_COUNTER_TYPE;

	T *				entity;
	mutable	REF_COUNTER_TYPE *	reference_counter;

private:
	void	detach() // throw()
	{
		if ( entity )
		{
			if ( reference_counter
			     == static_cast<REF_COUNTER_TYPE *>(0) )
			{
				delete[] entity;
			}
			else
			{
				if ( (-- (*reference_counter)) == 0 )
				{
					delete[] entity;
					delete reference_counter;
					entity
					 = static_cast<T *>(0);
					reference_counter
					 = static_cast<REF_COUNTER_TYPE *>(0);
				}
			}
		}
	}

	void	substitute( const ref_count_array_ptr &  ptr )
							 // throw(bad_alloc)
	{
		entity = ptr.entity;

		if ( entity )
		{
			if ( ptr.reference_counter
			     == static_cast<REF_COUNTER_TYPE *>(0) )
			{
				reference_counter = new REF_COUNTER_TYPE( 2 );
				ptr.reference_counter = reference_counter;
			}
			else
			{
				reference_counter = ptr.reference_counter;
				(*reference_counter) ++;
			}
		}
	}

	template<typename U>
	void	substitute( const ref_count_array_ptr<U> &  ptr )
							 // throw(bad_alloc)
	{
		entity = ptr.entity;

		if ( entity )
		{
			if ( ptr.reference_counter
			     == static_cast<REF_COUNTER_TYPE *>(0) )
			{
				reference_counter = new REF_COUNTER_TYPE( 2 );

				ptr.reference_counter = reference_counter;
			}
			else
			{
				reference_counter = ptr.reference_counter;
				(*reference_counter) ++;
			}
		}
	}

public:
	ref_count_array_ptr() // throw()
		: entity( static_cast<T *>(0) ) ,
		  reference_counter( static_cast<REF_COUNTER_TYPE *>(0) )
	{
	}

#ifdef REF_COUNT_ARRAY_PTR_USE_EXPLICIT
	explicit  ref_count_array_ptr( const ref_count_array_ptr &  ptr )
#else
	ref_count_array_ptr( const ref_count_array_ptr &  ptr )
#endif
		// throw(bad_alloc)
		: entity( static_cast<T *>(0) ) ,
		  reference_counter( static_cast<REF_COUNTER_TYPE *>(0) )
	{
		this -> substitute( ptr );
	}

	template<typename U>
#ifdef REF_COUNT_ARRAY_PTR_USE_EXPLICIT
	explicit ref_count_array_ptr( const ref_count_array_ptr<U> &  ptr )
#else
	ref_count_array_ptr( const ref_count_array_ptr<U> &  ptr )
#endif
		// throw(bad_alloc)
		: entity( static_cast<T *>(0) ) ,
		  reference_counter( static_cast<REF_COUNTER_TYPE *>(0) )
	{
		this -> substitute( ptr );
	}

#ifdef REF_COUNT_ARRAY_PTR_USE_EXPLICIT
	explicit  ref_count_array_ptr( const T * raw_pointer ) // throw()
#else
	ref_count_array_ptr( const T * raw_pointer ) // throw()
#endif
		: entity( const_cast<T *>(raw_pointer) ) ,
		  reference_counter( static_cast<REF_COUNTER_TYPE *>(0) )
	{
	}

	~ref_count_array_ptr() // throw()
	{
		this -> detach();
	}

	ref_count_array_ptr &  operator= ( const ref_count_array_ptr &  ptr )
		// throw(bad_alloc)
	{
		if ( ptr.entity == this -> entity )
		{
			return( *this );
		}
		else
		{
			this -> detach();

			this -> substitute( ptr );

			return( *this );
		}
	}

	template<typename U>
	ref_count_array_ptr &
		operator= ( const ref_count_array_ptr<U> &  ptr )
		// throw(bad_alloc)
	{
		if ( ptr.entity == this -> entity )
		{
			return( *this );
		}
		else
		{
			this -> detach();

			this -> substitute( ptr );

			return( *this );
		}
	}

	ref_count_array_ptr &  operator= ( const T *  raw_pointer ) // throw()
	{
		this -> detach();

		entity            = const_cast<T *>(raw_pointer);
		reference_counter = static_cast<REF_COUNTER_TYPE *>(0);

		return( *this );
	}

#if 0
	template<typename U>
	ref_count_array_ptr<U>  type_check() const
	{
		if ( dynamic_cast<U *>(entity) )
		{
			ref_count_array_ptr	u( *this );

			return( u );
		}
		else
		{
			return( ref_count_array_ptr<U>(0) );
		}
	}
#endif

	T &  operator* () const // throw()
	{
		return( *entity );
	}

	T *operator-> () const // throw()
	{
		return( entity );
	}

	T &  operator[] ( size_t  i ) const // throw()
	{
		return( entity[i] );
	}

	operator bool () const // throw()
	{
		return( entity != static_cast<T *>(0) );
	}

	template<typename U>
	bool	operator == ( const U *  ptr ) const
	{
		return( entity == ptr );
	}

	template<typename U>
	bool	operator != ( const U *  ptr ) const
	{
		return( entity != ptr );
	}

	template<typename U>
	bool	operator < ( const ref_count_array_ptr<const U> &  ptr ) const
	{
		return( entity < ptr.entity );
	}

	template<typename U>
	bool	operator < ( const ref_count_array_ptr<U> &  ptr ) const
	{
		return( entity < ptr.entity );
	}

	template<typename U>
	bool	operator < ( const U *  ptr ) const
	{
		return( entity < ptr );
	}

	T *  get() const // throw()
	{
		return( entity );
	}

	bool	null() const // throw()
	{
		return( entity == static_cast<T *>(0) );
	}

	void	release()
	{
		(*this) = static_cast<T *>(0);
	}
};


#endif	/* REF_COUNT_ARRAY_PTR_H_INCLUDED */
