#ifndef	   FD_IO_H_INCLUDED
#define	   FD_IO_H_INCLUDED

// Author:		H. Shimora
// Created:		Dec  3 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Dec  3 2002    base version.
//
//

#include  "abstract_io.h"
#include  "system_call_wrapper.h"
#include  <sys/types.h>
#include  <sys/time.h>
#include  "posix_compat_sys_select.h"
#include  <unistd.h>
#include  <cstdio>

class  FD_IO : public Abstract_IO
{
private:
	int	fd;
	bool	input_eof_flag;
	bool	output_eof_flag;

protected:
	void	initialize_fd( int  fd )
	{
		this -> fd = fd;
	}

public:
	FD_IO( int  fd )
		: fd( fd ) ,
		  input_eof_flag( false ) , output_eof_flag( false )
	{
	}

	virtual	~FD_IO()
	{
	}

	virtual	bool	input_valid() const
	{
		return ( true );
	}

	virtual	int	read( unsigned char *  buf ,  size_t  size )
	{
		int	ret;

		switch( (ret = ::read( this -> fd , buf , size )) )
		{
		case -1:
			std::perror( "read" );
			this -> input_eof_flag = true;
			this -> fd = -1;
			return( -1 );
			break;

		case 0:
			this -> input_eof_flag = true;
			this -> fd = -1;
			return( 0 );
			break;

		default:
			return( ret );
			break;
		}
	}


	virtual	bool	input_poll() const
	{
		if ( this -> fd == -1 )
		{
			return( false );
		}


		fd_set		readfd;
		FD_ZERO( &readfd );
		FD_SET( this -> fd , &readfd );

		struct timeval	tv;
		tv.tv_sec  = 0;
		tv.tv_usec = 0;

		switch( ::select( this -> fd + 1 ,
				  &readfd ,
				  static_cast<fd_set *>(0) ,
				  static_cast<fd_set *>(0) ,
				  &tv ) )
		{
		case -1:
			std::perror( "select" );
			return( false );

		case 0:
			return( false );

		default:
			return( true );
		}
	}

	virtual	std::vector<int>	input_fds() const
	{
		std::vector<int>	vec;

		if ( this -> fd != -1 )
		{
			vec.push_back( this -> fd );
		}

		return( vec );
	}

	virtual	bool	input_eof() const
	{
		return( this -> input_eof_flag );
	}

	virtual	bool	input_close()
	{
		this -> input_eof_flag = true;

		if ( this -> fd != -1 )
		{
			if ( ::close( this -> fd ) == -1 )
			{
				std::perror( "close" );

				return( false );
			}
		}

		return( true );
	}

	virtual	bool	output_valid() const
	{
		return ( true );
	}

	virtual	int	write( const unsigned char * const  buf ,
			       size_t  size )
	{
		return( System_Call_Wrapper::write_n_bytes
			( this -> fd , buf , size ) );
	}

	virtual	bool	output_eof() const
	{
		return( this -> output_eof_flag );
	}

	virtual	bool	output_close()
	{
		this -> output_eof_flag = true;

		if ( this -> fd != -1 )
		{
			if ( ::close( this -> fd ) == -1 )
			{
				std::perror( "close" );

				return( false );
			}
		}

		return( true );
	}
};


#endif	/* FD_IO_H_INCLUDED */
