/*
 * Decompiled with CFR 0.152.
 */
package daruma.auth;

import daruma.auth.Account;
import daruma.auth.PermissionDirective;
import daruma.auth.PermissionType;
import daruma.util.LogWriter;
import daruma.xml.UniversalName;
import java.util.ArrayList;
import java.util.List;

public class PermissionManager {
    private PermissionType defaultPermission;
    private List<PermissionDirective> directives;

    public PermissionManager(PermissionType defaultPermission) {
        this.defaultPermission = defaultPermission;
        this.directives = new ArrayList<PermissionDirective>();
    }

    public void addPermissionRule(PermissionDirective directive) {
        this.directives.add(directive);
    }

    public boolean canRead(Account account, UniversalName feature) {
        if (account == null) {
            return false;
        }
        for (PermissionDirective d : this.directives) {
            if (!d.getAccount().equals(account)) continue;
            return d.getAllowDeny() == PermissionType.Allow;
        }
        return this.defaultPermission == PermissionType.Allow;
    }

    public boolean canWrite(Account account, UniversalName feature) {
        return false;
    }

    public void debugPrint() {
        LogWriter.qwrite("DEBUG", "PermissionManager: " + this.directives.size() + " rule" + (this.directives.size() == 1 ? "" : "s"));
        for (PermissionDirective d : this.directives) {
            d.debugPrint();
        }
    }
}

