/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.PropertyPathConverter;
import daruma.xml.Lexicon;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLParseErrorException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyComparationPredicateDescription
extends PredicateDescription {
    private String sqlOperator;
    private String sqlExpression;
    private String propertyXPath;
    private Element xpathContext;
    private String value;
    private static Map<String, Pair<String, Integer>> operatorMap = new HashMap<String, Pair<String, Integer>>();

    public static boolean isAcceptablePredicate(String localName) {
        return operatorMap.containsKey(localName);
    }

    public PropertyComparationPredicateDescription(Element comparePredicateElement, TypeName typeName, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, typeName, type, trans);
        Pair<String, Integer> entry = operatorMap.get(comparePredicateElement.getLocalName());
        if (entry == null) {
            throw new XMLParseErrorException("cannot handle filter \"" + comparePredicateElement.getLocalName() + "\"");
        }
        this.sqlExpression = this.parsePropertyComparation(comparePredicateElement, entry);
    }

    @Override
    public String getSQLExpression() {
        return this.sqlExpression;
    }

    private String parsePropertyComparation(Element comp, Pair<String, Integer> entry) throws XMLParseErrorException {
        this.sqlOperator = entry.getFirst();
        int nArgs = entry.getSecond();
        List<Element> childElements = ElementUtil.getChildElements(comp);
        if (childElements.size() != nArgs) {
            throw new XMLParseErrorException("filter \"" + comp.getLocalName() + "\"" + " has invalid number of child elements," + " expected was " + nArgs);
        }
        Element propertyNameElement = childElements.get(0);
        Element literalElement = null;
        if (nArgs >= 2) {
            literalElement = childElements.get(1);
        }
        Lexicon.MispPropertyName.matchesOrXmlException(propertyNameElement, "in Property Compariton Operator");
        String literalString = null;
        if (nArgs >= 2) {
            Lexicon.MispLiteral.matchesOrXmlException(literalElement, "in Property Compariton Operator");
            literalString = ElementUtil.getChildNodesWholeText(literalElement);
        }
        String shortXPath = PropertyPathConverter.convertPropertyElementToShortXPath(propertyNameElement, super.getStorage());
        String sqlValueString = null;
        if (nArgs >= 2) {
            sqlValueString = this.convertValueToSQL(shortXPath, literalString);
        }
        String leftArg = shortXPath;
        String rightArg = null;
        if (nArgs >= 2) {
            rightArg = shortXPath.equals("_transaction_id_") ? this.genSubQueryForTransactionSN(literalString) : "'" + sqlValueString + "'";
        }
        this.propertyXPath = ElementUtil.getChildNodesWholeText(propertyNameElement);
        this.xpathContext = propertyNameElement;
        this.value = literalString;
        if (nArgs >= 2) {
            return leftArg + ' ' + this.sqlOperator + ' ' + rightArg;
        }
        return leftArg + ' ' + this.sqlOperator;
    }

    private String convertValueToSQL(String columnName, String value) throws XMLParseErrorException {
        SQLDataType sqlType = super.getTypeDefinition().getSingleSQLDataType();
        if (sqlType == null) {
            List<TableColumnDefinition> columns;
            try {
                columns = super.getTypeDefinition().getCompositeSQLDataType(super.getStorage(), null, null);
            }
            catch (TypeException e) {
                throw new XMLParseErrorException("type definition error", e);
            }
            for (TableColumnDefinition c : columns) {
                if (!c.getColumnName().equals(columnName)) continue;
                sqlType = c.getSQLDataType();
                break;
            }
        }
        if (sqlType == null) {
            if (columnName.equals("_transaction_id_")) {
                sqlType = new SQLDataType("integer", Integer.class);
            } else if (columnName.equals("_create_time_") || columnName.equals("_update_time_")) {
                sqlType = SQLDataTypeConstant.TIMESTAMP;
            }
        }
        if (sqlType == null) {
            LogWriter.qwrite("DEBUG", "columnName [", columnName, "] not found");
            throw new XMLParseErrorException("property not found");
        }
        if (sqlType.isTimeFamilyType()) {
            ISO8601DateFormat dateParser = new ISO8601DateFormat();
            Date date = dateParser.parse(value, new ParsePosition(0));
            if (date == null) {
                throw new XMLParseErrorException("Illegal datetime format: '" + value + "'" + " It should be yyyy-mm-ddThh:mm:ss.sss" + "[+/-]HH:MM");
            }
            String dateString = SQLTimeFormatConverter.convertDateToString(date);
            return dateString;
        }
        return value;
    }

    private String genSubQueryForTransactionSN(String uriString) {
        return "ifnull((select id from __transaction_log__ where uri='" + uriString + "'" + ")" + "," + "0" + ")";
    }

    @Override
    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return true;
    }

    static {
        operatorMap.put(Lexicon.MispFilterPropertyIsEqualTo.getUniversalName().getLocalName(), new Pair<String, Integer>("=", 2));
        operatorMap.put(Lexicon.MispFilterPropertyIsLessThan.getUniversalName().getLocalName(), new Pair<String, Integer>("<", 2));
        operatorMap.put(Lexicon.MispFilterPropertyIsGreaterThan.getUniversalName().getLocalName(), new Pair<String, Integer>(">", 2));
        operatorMap.put(Lexicon.MispFilterPropertyIsLessThanOrEqualTo.getUniversalName().getLocalName(), new Pair<String, Integer>("<=", 2));
        operatorMap.put(Lexicon.MispFilterPropertyIsGreaterThanOrEqualTo.getUniversalName().getLocalName(), new Pair<String, Integer>(">=", 2));
        operatorMap.put(Lexicon.MispFilterPropertyIsNull.getUniversalName().getLocalName(), new Pair<String, Integer>("IS NULL", 1));
    }
}

