package daruma.geometry;

import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmPoint;

import java.util.List;
import java.util.ArrayList;

import com.vividsolutions.jts.geom.* ;
import com.vividsolutions.jts.geom.impl.* ;
import daruma.geometry.OgcGeometryFactory ;

public class DrmLinearRing extends DrmGeometry
{
	private	List<DrmPoint>	points;

	public	DrmLinearRing()
	{
		this.points = new ArrayList<DrmPoint>();
	}

	public	DrmLinearRing( List<DrmPoint>  points )
	{
		this();

		for ( DrmPoint p : points )
		{
			this.add( p );
		}
	}

	public	void	add( DrmPoint  point )
	{
		this.points.add( point );
	}

	public	List<DrmPoint>	getPoints()
	{
		return( this.points );
	}

	public	DrmPoint	get( int  index )
	{
		return( this.points.get( index ) );
	}

	public	boolean	closed()
	{
		if ( this.getPoints().size() == 0 )
		{
			return( false );
		}

		return( this.points.get(0)
			.equals( this.points.get(this.points.size() - 1)) );
	}

	@Override
	public DrmLinearRing transform( CoordinateSystemTransformation trans )
	    throws TransformationException
	{
		DrmLinearRing ret = new DrmLinearRing();

		for ( DrmPoint p : points )
		{
			ret.add( trans.transform( p ) );
		}

		return ret;
	}


    //------------------------------------------------------------
    /**
     * geometry generator
     */
    @Override
    public LinearRing genGeometry(OgcGeometryFactory geoFactory) {
	CoordinateSequence coords = geoFactory.newCoords(points.size(), 2) ;

	int i = 0 ;
	for(DrmPoint point : points) {
	    if ( point.getDimension() == 3 ) {
		geoFactory.setCoordinate3D(coords,i,point.getX(), point.getY(),point.getZ()) ;
	    } else {
		geoFactory.setCoordinate2D(coords,i,point.getX(), point.getY()) ;
	    }

	    i++ ;
	}

	return geoFactory.createLinearRing(coords) ;
    }
}
