package daruma.storage_manager;

import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.SimpleXPath;
import daruma.util.LogWriter;

import java.util.Map;
import java.util.HashMap;


public class ElementInfo
{
    private Map<SimpleXPath, TypeDefinition> pathMap = new HashMap<SimpleXPath, TypeDefinition>();

    public ElementInfo()
    {
    }

    /**
     * register mapping of sub element path and its type
     */
    public void registerSubElement( SimpleXPath path, TypeDefinition type )
    {
	this.pathMap.put( path, type );
    }

    /**
     * search type of sub element
     *
     * if sub element was not found, this method returns null.
     */
    public TypeDefinition getTypeDefinition( SimpleXPath path )
    {
	return this.pathMap.get( path );
    }

    public void debugPrint()
    {
	LogWriter.qwrite( "DEBUG",
			  "ElementInfo: number of sub elements = ",
			  this.pathMap.size() );

	for ( Map.Entry<SimpleXPath, TypeDefinition> e
		  : this.pathMap.entrySet() )
	{
	    LogWriter.qwrite( "DEBUG",
			      "[", e.getKey(), "]: [",
			      e.getValue(), "]" );
	}
    }
}
