package daruma.xml;

import org.w3c.dom.Element;

import daruma.util.NullCheckComparator;


public class UniversalName implements Comparable<UniversalName>
{
	private	String	namespaceURI;
	private	String	localName;

	public	UniversalName( String  namespaceURI ,  String  localName )
	{
		if ( namespaceURI != null
		  && namespaceURI.equals( "" ) )
		{
			this.namespaceURI = null;
		}
		else
		{
			this.namespaceURI = namespaceURI;
		}

		this.localName = localName;
	}

	public	UniversalName( Element  element )
	{
		this( element.getNamespaceURI() , element.getLocalName() );
	}

	public	String	getNamespace()
	{
		return( this.namespaceURI );
	}

	public	String	getNamespaceNonNull()
	{
		if ( this.namespaceURI == null )
		{
			return( "" );
		}

		return( this.namespaceURI );
	}

	public	String	getLocalName()
	{
		return( this.localName );
	}

	public	boolean	equals( UniversalName  n )
	{
		if ( n == null )
		{
			return( false );
		}

		return( ((this.localName == null && n.localName == null)
			 || this.localName.equals( n.localName ))
		     && ((this.namespaceURI == null && n.namespaceURI == null)
			 || this.namespaceURI.equals( n.namespaceURI )) );
	}

	public	boolean	equals( Object  n )
		/* n should be an instance of UniversalName */
	{
		assert( n instanceof UniversalName );

		return( this.equals( (UniversalName)n ) );
	}

	public	int	hashCode()
	{
		int	localNameHashCode
			  = ( this.localName == null ?
			      0 : this.localName.hashCode() );

		int	namespaceURIHashCode
			  = ( this.namespaceURI == null ?
			      0 : this.namespaceURI.hashCode() );

		return( localNameHashCode ^ namespaceURIHashCode );
	}

	public	int	compareTo( UniversalName u )
	{
		if ( u == null )
		{
			return 1;
		}

		final int c = NullCheckComparator.staticCompare
			      ( this.namespaceURI, u.namespaceURI );

		if ( c != 0 )
		{
		    return c;
		}

		return NullCheckComparator.staticCompare
		       ( this.localName, u.localName );
	}

	public	String	toString()
	{
		return( "{" + (this.namespaceURI == null ?
			       "" : this.namespaceURI)
			+ "}" + this.localName );
	}
}
