/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.Point;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.DrmGeometry;
import daruma.geometry.OgcGeometryFactory;
import daruma.geometry.TransformationException;

public class DrmPoint
extends DrmGeometry {
    private int dimension;
    private double x;
    private double y;
    private double z;

    public DrmPoint(double x, double y) {
        this.dimension = 2;
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public DrmPoint(double x, double y, double z) {
        this.dimension = 3;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean equals(Object point) {
        assert (point instanceof DrmPoint);
        return this.equals((DrmPoint)point);
    }

    public boolean equals(DrmPoint point) {
        return this.dimension == point.dimension && Double.doubleToLongBits(this.x) == Double.doubleToLongBits(point.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(point.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(point.z);
    }

    public int hashCode() {
        return Integer.valueOf(this.dimension).hashCode() ^ Double.valueOf(this.x).hashCode() ^ Double.valueOf(this.y).hashCode() ^ Double.valueOf(this.z).hashCode();
    }

    public Point genGeometry(OgcGeometryFactory geoFactory) {
        if (this.dimension == 3) {
            return geoFactory.genPoint3D(this.x, this.y, this.z);
        }
        return geoFactory.genPoint2D(this.x, this.y);
    }

    public DrmPoint transform(CoordinateSystemTransformation trans) throws TransformationException {
        return trans.transform(this);
    }
}

