/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class OgcGeometryFactory
extends GeometryFactory {
    private static final long serialVersionUID = 0L;

    public CoordinateSequence genCoords2D(double ... xyList) {
        return this.genCoords(2, xyList);
    }

    public CoordinateSequence genCoords3D(double ... xyzList) {
        return this.genCoords(3, xyzList);
    }

    public CoordinateSequence genCoords(int dimensionN, double ... values) {
        return this.genCoordsBody(false, dimensionN, values);
    }

    public CoordinateSequence genClosedCoords2D(double ... xyList) {
        return this.genClosedCoords(2, xyList);
    }

    public CoordinateSequence genClosedCoords3D(double ... xyzList) {
        return this.genClosedCoords(3, xyzList);
    }

    public CoordinateSequence genClosedCoords(int dimensionN, double ... values) {
        return this.genCoordsBody(true, dimensionN, values);
    }

    private CoordinateSequence genCoordsBody(boolean isClosed, int dimensionN, double ... values) {
        CoordinateSequence coord = null;
        int valueN = values.length;
        if (valueN % dimensionN == 0) {
            int coordN = valueN / dimensionN;
            coord = isClosed ? this.newCoords(coordN + 1, dimensionN) : this.newCoords(coordN, dimensionN);
            for (int i = 0; i < coordN; ++i) {
                for (int j = 0; j < dimensionN; ++j) {
                    coord.setOrdinate(i, j, values[i * dimensionN + j]);
                }
            }
            if (isClosed) {
                for (int j = 0; j < dimensionN; ++j) {
                    coord.setOrdinate(coordN, j, values[j]);
                }
            }
        }
        return coord;
    }

    public CoordinateSequence newCoords(int size, int dimensionN) {
        return this.getCoordinateSequenceFactory().create(size, dimensionN);
    }

    public Point genPoint2D(double x, double y) {
        return this.createPoint(this.genCoords2D(x, y));
    }

    public Point genPoint3D(double x, double y, double z) {
        return this.createPoint(this.genCoords3D(x, y, z));
    }

    public LineString genLineString2D(double ... xyList) {
        return this.createLineString(this.genCoords2D(xyList));
    }

    public LineString genLineString3D(double ... xyzList) {
        return this.createLineString(this.genCoords3D(xyzList));
    }

    public LinearRing genLinearRing2D(double ... xyList) {
        return this.createLinearRing(this.genClosedCoords2D(xyList));
    }

    public LinearRing genLinearRing3D(double ... xyzList) {
        return this.createLinearRing(this.genClosedCoords3D(xyzList));
    }

    public Polygon genSimplePolygon2D(double ... xyList) {
        return this.createPolygon(this.genLinearRing2D(xyList), null);
    }

    public Polygon genSimplePolygon3D(double ... xyzList) {
        return this.createPolygon(this.genLinearRing3D(xyzList), null);
    }

    public static void setCoordinate2D(CoordinateSequence coords, int index, double x, double y) {
        coords.setOrdinate(index, 0, x);
        coords.setOrdinate(index, 1, y);
    }

    public static void setCoordinate3D(CoordinateSequence coords, int index, double x, double y, double z) {
        coords.setOrdinate(index, 0, x);
        coords.setOrdinate(index, 1, y);
        coords.setOrdinate(index, 2, z);
    }
}

