/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.geometry.DrmGeometry;
import daruma.global_switch.ImplementationSwitches;
import daruma.sql.DatabaseCalendarConfig;
import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumn;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUpdator {
    private ElementUpdator() {
    }

    public static int executeUpdate(DatabaseConnection db, String tableName, List<TableColumn> columns, long transactionSN, String whereBlock) throws DatabaseConnectionException {
        int ret;
        PreparedStatement st = ElementUpdator.getPreparedStatement(db, tableName, columns, whereBlock);
        ElementUpdator.setValuesToPreparedStatement(db, st, transactionSN, columns);
        try {
            ret = db.executeUpdate(st);
            st.close();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
        return ret;
    }

    public static void executeBulkUpdate(DatabaseConnection db, String tableName, List<TypedInstance> objs, long transactionSN, String whereBlock) throws DatabaseConnectionException {
        PreparedStatement st = ElementUpdator.getPreparedStatement(db, tableName, objs.get(0).getColumns(), whereBlock);
        for (TypedInstance obj : objs) {
            List<TableColumn> columns = obj.getColumns();
            ElementUpdator.setValuesToPreparedStatement(db, st, transactionSN, columns);
            try {
                st.addBatch();
                st.clearParameters();
            }
            catch (SQLException e) {
                LogWriter.qwrite("DEBUG", "add batch failed, ", e.getMessage());
                if (e.getNextException() != null) {
                    LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage(), "]");
                }
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }
        try {
            st.executeBatch();
            st.close();
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "update failed, ", e.getMessage());
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage(), "]");
            }
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    private static PreparedStatement getPreparedStatement(DatabaseConnection db, String tableName, List<TableColumn> columns, String whereBlock) throws DatabaseConnectionException {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE " + tableName + " SET ");
        int wildcardCount = 0;
        s.append("_transaction_id_");
        s.append("=?");
        ++wildcardCount;
        s.append(",");
        s.append("_create_time_");
        s.append("=");
        s.append("_create_time_");
        s.append(",");
        s.append("_update_time_");
        s.append("=?");
        ++wildcardCount;
        for (TableColumn c : columns) {
            s.append(",");
            s.append(c.getDefinition().getColumnName());
            s.append("=");
            Class javaClass = c.getDefinition().getSQLDataType().getJavaClass();
            if (DrmGeometry.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("GeomFromText(?)");
                continue;
            }
            if (Date.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("?");
                continue;
            }
            ++wildcardCount;
            s.append("?");
        }
        s.append(" WHERE ");
        s.append(whereBlock);
        LogWriter.qwrite("DEBUG", "#", s);
        PreparedStatement st = null;
        st = db.prepareStatement(s.toString());
        return st;
    }

    private static void setValuesToPreparedStatement(DatabaseConnection db, PreparedStatement st, long transactionSerialNumber, List<TableColumn> columns) throws DatabaseConnectionException {
        try {
            int wildcardIndex = 1;
            st.setLong(wildcardIndex, new Long(transactionSerialNumber));
            ++wildcardIndex;
            Date currentTime = db.getCurrentTime();
            if (ImplementationSwitches.instance().isMySQLBackend()) {
                st.setString(wildcardIndex, SQLTimeFormatConverter.convertDateToString(currentTime));
                ++wildcardIndex;
            } else {
                st.setTimestamp(wildcardIndex, new Timestamp(currentTime.getTime()), DatabaseCalendarConfig.getCalendar());
                ++wildcardIndex;
            }
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn col = columns.get(i);
                if (col.isEmptyColumn() || col.getValue() == null) {
                    st.setNull(wildcardIndex, 0);
                    ++wildcardIndex;
                    continue;
                }
                Class c = col.getDefinition().getSQLDataType().getJavaClass();
                if (c.equals(String.class)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Boolean.class)) {
                    boolean value = Boolean.parseBoolean(col.getValue());
                    st.setBoolean(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Double.class)) {
                    double value = Double.parseDouble(col.getValue());
                    st.setDouble(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Float.class)) {
                    float value = Float.parseFloat(col.getValue());
                    st.setFloat(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Long.class)) {
                    long value = Long.parseLong(col.getValue());
                    st.setLong(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Integer.class)) {
                    int value = Integer.parseInt(col.getValue());
                    st.setInt(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (Date.class.isAssignableFrom(c)) {
                    ISO8601DateFormat f = new ISO8601DateFormat();
                    Date dateTime = f.parse(col.getValue(), new ParsePosition(0));
                    if (dateTime == null) {
                        throw new DatabaseConnectionException("invalid time format, value = [" + col.getValue() + "]");
                    }
                    if (ImplementationSwitches.instance().isMySQLBackend()) {
                        st.setString(wildcardIndex, SQLTimeFormatConverter.convertDateToString(dateTime));
                    } else {
                        st.setTimestamp(wildcardIndex, new Timestamp(dateTime.getTime()), DatabaseCalendarConfig.getCalendar());
                    }
                    ++wildcardIndex;
                    continue;
                }
                if (DrmGeometry.class.isAssignableFrom(c)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                st.setString(wildcardIndex, col.getValue());
                ++wildcardIndex;
            }
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }
}

