/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import java.util.HashSet;
import java.util.Set;

public class StringTypeDefinition
extends AbstractSingleTypeDefinition {
    private long minLength = -1L;
    private long maxLength = -1L;
    private Set<String> enumerationSet = null;

    public SQLDataType getSingleSQLDataType() {
        return SQLDataTypeConstant.BLOB;
    }

    public String parseValue(String value) throws TypeException {
        if (this.minLength != -1L && (long)value.length() < this.minLength) {
            throw new TypeException("too short string \"" + value + "\"");
        }
        if (this.maxLength != -1L && (long)value.length() > this.maxLength) {
            throw new TypeException("too long string \"" + value + "\"");
        }
        if (this.enumerationSet != null && !this.enumerationSet.contains(value)) {
            throw new TypeException("value \"" + value + "\"" + " is not a valid member" + " of enumeration set");
        }
        return value;
    }

    public void setMinLength(long limit) {
        assert (limit >= 0L);
        this.minLength = limit;
    }

    public void setMaxLength(long limit) {
        assert (limit >= 0L);
        this.maxLength = limit;
    }

    public void addEnumeration(String value) {
        if (this.enumerationSet == null) {
            this.enumerationSet = new HashSet<String>();
        }
        this.enumerationSet.add(value);
    }

    public StringTypeDefinition deepCopy() {
        StringTypeDefinition ret = new StringTypeDefinition();
        ret.minLength = this.minLength;
        ret.maxLength = this.minLength;
        if (this.enumerationSet != null) {
            ret.enumerationSet = new HashSet<String>(this.enumerationSet);
        }
        return ret;
    }
}

