/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import daruma.util.ParseException;

public class TextUtil {
    private TextUtil() {
    }

    public static double[][] parseMatrixValue(String parameterString, long size1, long size2) throws ParseException {
        String[] params = parameterString.trim().split("[ \t\n]+");
        if ((long)params.length != size1 * size2) {
            throw new ParseException("number of parameters mismatch, expected was " + size1 * size2 + ", " + "found was " + params.length);
        }
        double[][] t = new double[(int)size1][(int)size2];
        for (long i = 0L; i < size1; ++i) {
            for (long j = 0L; j < size2; ++j) {
                double v = 0.0;
                String valueString = params[(int)(i * size2 + j)];
                try {
                    v = new Double(valueString);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("number format error, [" + valueString + "]", e);
                }
                t[(int)i][(int)j] = v;
            }
        }
        return t;
    }
}

