/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeName;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.PropertyPathConverter;
import daruma.xml.URI;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLParseErrorException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyIsMaxMinPredicateDescription
extends PredicateDescription {
    private static final String PROPERTY_IS_MAX = "PropertyIsMax";
    private static final String PROPERTY_IS_MIN = "PropertyIsMin";
    private static final String PROPERTY_NAME = "PropertyName";
    private static final String UNIQUE_GROUP_BY = "UniqueGroupBy";
    private String sqlExpression;

    public static boolean isAcceptablePredicate(String localName) {
        return localName.equals(PROPERTY_IS_MAX) || localName.equals(PROPERTY_IS_MIN);
    }

    public String getSQLExpression() {
        return this.sqlExpression;
    }

    public PropertyIsMaxMinPredicateDescription(Element element, TypeName typeName, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, typeName, type, trans);
        String featureTableName;
        List<Element> childElements = ElementUtil.getChildElements(element);
        if (childElements.size() != 1 && childElements.size() != 2) {
            throw new XMLParseErrorException("filter \"" + element.getLocalName() + "\"" + " has invalid number of child elements," + " expected was 1 or 2");
        }
        Element propertyNameElement = childElements.get(0);
        Element uniqueGroupByElement = null;
        boolean haveUniqueGroupByElement = false;
        if (!propertyNameElement.getLocalName().equals(PROPERTY_NAME) || !propertyNameElement.getNamespaceURI().equals(URI.MISP)) {
            throw new XMLParseErrorException("unexpected \"" + propertyNameElement.getLocalName() + "\"" + " in namespace " + propertyNameElement.getNamespaceURI() + "," + " expected was \"" + PROPERTY_NAME + "\" in namespace " + URI.MISP);
        }
        if (childElements.size() == 2) {
            haveUniqueGroupByElement = true;
            uniqueGroupByElement = childElements.get(1);
            if (!uniqueGroupByElement.getLocalName().equals(UNIQUE_GROUP_BY) || !propertyNameElement.getNamespaceURI().equals(URI.MISP)) {
                throw new XMLParseErrorException("unexpected \"" + uniqueGroupByElement.getLocalName() + "\"" + " in namespace " + uniqueGroupByElement.getNamespaceURI() + "," + " expected was \"" + UNIQUE_GROUP_BY + "\" in namespace " + URI.MISP);
            }
        }
        String propertyXPath = PropertyPathConverter.convertPropertyElementToShortXPath(propertyNameElement, super.getStorage());
        String func = element.getLocalName().equals(PROPERTY_IS_MAX) ? "MAX" : "MIN";
        try {
            featureTableName = storage.getUniversalNameID(typeName);
        }
        catch (StorageException e) {
            throw new XMLParseErrorException(e);
        }
        if (haveUniqueGroupByElement) {
            List<Element> uniqChildElements = ElementUtil.getChildElements(uniqueGroupByElement);
            if (uniqChildElements.size() != 1) {
                throw new XMLParseErrorException("element \"" + uniqueGroupByElement.getLocalName() + "\"" + " has invalid number of child elements," + " expected was 1");
            }
            Element idPropertyNameElement = uniqChildElements.get(0);
            if (!idPropertyNameElement.getLocalName().equals(PROPERTY_NAME) || !idPropertyNameElement.getNamespaceURI().equals(URI.MISP)) {
                throw new XMLParseErrorException("unexpected \"" + idPropertyNameElement.getLocalName() + "\"" + " in namespace " + idPropertyNameElement.getNamespaceURI() + "," + " expected was \"" + PROPERTY_NAME + "\" in namespace " + URI.MISP);
            }
            String idPropertyXPath = PropertyPathConverter.convertPropertyElementToShortXPath(idPropertyNameElement, super.getStorage());
            String defaultSetName = "_s";
            String tmpSetName = "_s_";
            this.sqlExpression = propertyXPath + " = " + "(SELECT " + func + "(" + "_s_" + "." + propertyXPath + ") FROM " + featureTableName + " " + "_s_" + " WHERE " + "_s_" + "." + idPropertyXPath + " = " + "_s" + "." + idPropertyXPath + ")";
        } else {
            this.sqlExpression = propertyXPath + " = " + "(SELECT " + func + "(" + propertyXPath + ") FROM " + featureTableName + ")";
        }
    }

    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return true;
    }
}

