/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.util;

import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.DeclaredName;
import daruma.xml.NameSpace;
import daruma.xml.UniversalName;
import daruma.xml.util.PrefixMap;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    private static String separatorStr = "___never_occur_string_I_hope___";

    private ElementUtil() {
    }

    public static boolean hasExtraChildElements(Element element, int beginChildIndex) {
        NodeList childNodes = element.getChildNodes();
        for (int i = beginChildIndex; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public static List<Element> getExtraChildElements(Element element, int beginChildIndex) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            ret.add((Element)n);
        }
        return ret;
    }

    public static String getChildNodesWholeText(Element element) {
        return element.getTextContent();
    }

    public static String getStringOnlyChildNodesWholeText(Element element) throws XMLParseErrorException {
        if (ElementUtil.getChildElements(element).size() != 0) {
            throw new XMLParseErrorException("element [" + new UniversalName(element) + "] should not contain any tags.");
        }
        return ElementUtil.getChildNodesWholeText(element);
    }

    public static List<Element> getChildElements(Element element) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            ret.add((Element)n);
        }
        return ret;
    }

    public static Element getSingleChildElement(Element element) throws XMLParseErrorException {
        NodeList childNodes = element.getChildNodes();
        Element ret = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            if (ret != null) {
                throw new XMLParseErrorException("too many child elements of element " + element.getLocalName() + " in namespace " + element.getNamespaceURI() + " found");
            }
            ret = (Element)n;
        }
        if (ret == null) {
            throw new XMLParseErrorException("empty child element of element \"" + element.getLocalName() + "\" in namespace \"" + element.getNamespaceURI() + "\"");
        }
        return ret;
    }

    public static Element getNameReplacedElement(Element originalElement, UniversalName nameToReplace, Document doc) {
        Element replaced = doc.createElementNS(nameToReplace.getNamespace(), nameToReplace.getLocalName());
        NodeList childNodes = originalElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            replaced.appendChild(childNodes.item(i).cloneNode(true));
        }
        return replaced;
    }

    public static void debugPrint(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                LogWriter.qwrite("DEBUG", i, ": ", "Element {", e.getNamespaceURI(), "}", e.getLocalName());
                continue;
            }
            if (n instanceof Text) {
                LogWriter.qwrite("DEBUG", i, ": ", "Text [", ((Text)n).getWholeText(), "]");
                continue;
            }
            LogWriter.qwrite("DEBUG", i, ": ", "???");
        }
    }

    public static void addPrefixMappingToElement(Element element, PrefixMap prefixMap) {
        for (Map.Entry<String, String> e : prefixMap.entrySet()) {
            NameSpace.addNsDeclToIfNeeded(element, e.getKey(), e.getValue());
        }
    }

    public static void addPrefixMappingToPrefixMap(PrefixMap prefixMap, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String pref = attr.getPrefix();
            if (pref != null && pref.equals("xmlns")) {
                prefixMap.put(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (pref != null || !attr.getLocalName().equals("xmlns")) continue;
            prefixMap.put("", attr.getValue());
        }
        String namespaceURI = node.getNamespaceURI();
        if (namespaceURI != null) {
            prefixMap.put(node.getPrefix(), namespaceURI);
        }
    }

    public static Element genElementSimple(DeclaredName dname, String text, Document document, Node parent) {
        return ElementUtil.genElementSimple(dname, text, document, parent, false);
    }

    public static Element genElementSimple(DeclaredName dname, String text, Document document, Node parent, boolean useParentPrefix) {
        return ElementUtil.genElementSimple(dname.ns, dname.localname, text, document, parent, useParentPrefix);
    }

    public static Element genElementSimple(NameSpace ns, String localName, String text, Document document, Node parent) {
        return ElementUtil.genElementSimple(ns, localName, text, document, parent, false);
    }

    public static Element genElementSimple(NameSpace ns, String localName, String text, Document document, Node parent, boolean useParentPrefix) {
        return ElementUtil.genElementSimple(ns.defaultPrefix, ns.uri, localName, text, document, parent, useParentPrefix);
    }

    public static Element genElementSimple(String prefix, String nsUri, String localName, String text, Document document, Node parent) {
        return ElementUtil.genElementSimple(prefix, nsUri, localName, text, document, parent, false);
    }

    public static Element genElementSimple(String prefix, String nsUri, String localName, String text, Document document, Node parent, boolean useParentPrefix) {
        String predefined;
        if (useParentPrefix && (predefined = NameSpace.findPredefinedPrefixIn(parent, nsUri)) != null) {
            prefix = predefined;
        }
        String qname = localName;
        if (prefix != null && prefix.length() > 0) {
            qname = NameSpace.genQName(prefix, localName);
        }
        Element element = document.createElementNS(nsUri, qname);
        if (parent != null) {
            parent.appendChild(element);
        }
        if (text != null && text.length() > 0) {
            element.appendChild(document.createTextNode(text));
        }
        return element;
    }

    public static Text addTextNode(Node parent, String text, Document doc) {
        Text textNode = doc.createTextNode(text);
        parent.appendChild(textNode);
        return textNode;
    }

    public static Pair<String, String> splitToHeaderTailerStrAt(Node root, Node leaf, boolean withDocDeclP) throws TransformerException {
        return ElementUtil.splitToHeaderTailerStrAt(root, leaf, null, withDocDeclP);
    }

    public static Pair<String, String> splitToHeaderTailerStrAt(Node root, Node leaf, Node at, boolean withDocDeclP) throws TransformerException {
        Document doc = root instanceof Document ? (Document)root : root.getOwnerDocument();
        Text separator = doc.createTextNode(separatorStr);
        leaf.insertBefore(separator, at);
        Pair<String, String> headerTailer = XMLFormatConverter.splitToHeaderTailerStrBy(root, separatorStr, withDocDeclP);
        leaf.removeChild(separator);
        return headerTailer;
    }

    public static String getAttributeValue(Element element, DeclaredName dname, String defaultValue) {
        String attrValue = null;
        String nsURI = dname.ns == null ? null : dname.ns.uri;
        attrValue = element.hasAttributeNS(nsURI, dname.localname) ? element.getAttributeNS(nsURI, dname.localname) : defaultValue;
        return attrValue;
    }
}

