package daruma.util;

import java.util.Comparator;

public class NullCheckComparator<T extends Comparable<T>> implements Comparator<T>
{
    private NullCheckComparator()
    {
    }

    public int compare( T a, T b )
    {
	return staticCompare( a, b );
    }

    public static <T extends Comparable<T>> int staticCompare( T a, T b )
    {
	if ( a == b )
	{
	    return 0;
	}

	if ( a == null )
	{
	    return -1;
	}
	else if ( b == null )
	{
	    return 1;
	}

	return a.compareTo( b );
    }
}
