package daruma.util;

import java.io.*;
import java.util.Properties;
import java.util.ArrayList;

import daruma.util.LogWriter;

/**
 * Propertyեѥ饹<BR>
 * եͤɤ߹िΥ饹Ǥ
 */
public class PropertyReader {
	// ɸPropertyե̾
	private final static String DEFAULT_PROPERTY_FILE = "daruma.properties";

	// Propertyե̾򼨤ƥץѥƥ̾
	private final static String PROPERTY_NAME = "daruma.properties";

	private static String cPropertyFile;

	// ץѥƥեΥ֥
	private static Properties prop = null;

	/**
	 * 󥹥ȥ饯<BR>
	 * Фεư1٤ƤФ졢PropertyͤHashTable˳Ǽޤ<BR>
	 * Υ饹ˤPropertyͤɤ߹ߤˤäơեѥ
	 * ǧ뤿ᡢΥ饹ΥϤϤޤ<BR>
	 *
	 * @exception FileNotFoundException ץѥƥե뤬¸ߤʤ<BR>
	 * @exception IOException ץѥƥեϥ顼ȯ<BR>
	 */
	private static void initialize() throws FileNotFoundException {
	    initialize( System.getProperty( PROPERTY_NAME,
					    DEFAULT_PROPERTY_FILE) );
	}

	public static void initialize( String path )
	    throws FileNotFoundException {
	    cPropertyFile = path;

	    initialize( new FileInputStream(cPropertyFile) );
	}

	public static void initialize( InputStream in ) {
		try {
			// Propertyեɤ߹
			prop = new Properties();

			// ץѥƥꥹȤɤ߹
			prop.load(in);
		} catch (FileNotFoundException e) {
			// ե뤬¸ߤʤ
			System.err.println("ERROR [PropertyReader] " + e.getMessage());
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		} catch(IOException e) {
			// Ϥ˼Ԥ
			System.err.println("ERROR [PropertyReader] " + e.getMessage());
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch(IOException e) {
					System.err.println("ERROR [PropertyReader] " + e.getMessage());
					e.printStackTrace();
					throw new RuntimeException(e.getMessage());
				}
			}
		}
	}

	/**
	 * ץѥƥե뤫Propertyͤޤ<BR>
	 * ǥե꤬ʤ˸ƤФޤ<BR>
	 * Propertyͤ¸ߤʤnull֤ޤ<BR>
	 * @param propName Property̾
	 * @return ץѥƥե뤫ʸ󷿤Υץѥƥ
	 */
	public static String getProperty(String propName) {
		return getProperty(propName, null);
	}

	/**
	 * ץѥƥե뤫Propertyͤޤ<BR>
	 * Property̾бͤĤʤϡ
	 * ꤵ줿ǥեֵͤѤޤ<BR>
	 *
	 * @param propName Property̾
	 * @param def ץѥƥ̾ĤʤΥǥե
	 * @return ץѥƥե뤫ʸ󷿤Υץѥƥ
	 */
	public static String getProperty(String propName, String def) {

		if(prop == null) {
			try {
				initialize();
			} catch( FileNotFoundException e ) {
				e.printStackTrace();
			}
		}

		return prop.getProperty(propName, def);
	}

	/**
	 * ץѥƥե뤫Propertyͤޤ<BR>
	 * Property̾бͤĤʤϡ
	 * ǥեֵͤѤޤ<BR>
	 * ޤǥեͤboolean˥㥹ȤǤʤäϡ
	 * false֤ޤ
	 *
	 * @param propName Property̾
	 * @param def ץѥƥ̾ĤʤΥǥե
	 * @return ץѥƥե뤫booleanΥץѥƥ
	 */
	public static boolean getProperty(String propName, boolean def) {
		String value = Boolean.toString(def);

		return getPropertyBoolean(propName, value);
	}

	/**
	 * ץѥƥե뤫PropertyͤǼޤ<BR>
	 * Property̾бͤĤʤϡ
	 * nullֵѤޤ<BR>
	 *
	 * @param propName Property̾
	 * @return ץѥƥե뤫ArrayListΥץѥƥ
	 */
	public static ArrayList getArrayProperty(String propName) {
		int i = 0;
		ArrayList<String> array_value = new ArrayList<String>();
		while (true) {
			// PropertyKEYκ
			String array_kind = propName + "." + i;
			// Propertyͤμ
			String result = getProperty(array_kind);
			if (result != null) {
				// ArrayListسǼ
				array_value.add(result);
			} else {
				break;
			}
			i++;
		}
		return array_value;
	}

	/**
	 * ץѥƥե뤫PropertyͤintǼޤ<BR>
	 * ǥե꤬ʤ˸ƤФޤ<BR>
	 *
	 * @param propName Property̾
	 * @return ץѥƥե뤫intΥץѥƥ
	 */
	public static int getPropertyInt(String propName) {
		return getProperty(propName, 0);
	}

	/**
	 * ץѥƥե뤫PropertyͤintǼޤ<BR>
	 * Property̾бͤĤʤϡ
	 * 0ֵѤޤ<BR>
	 *
	 * @param propName Property̾
	 * @param def ǥե
	 * @return ץѥƥե뤫intΥץѥƥ
	 */
	public static int getProperty(String propName, int def) {
		String value = getProperty(propName, Integer.toString(def));
		int result = 0;
		try {
			// ͤ¸ߤʤȤꤵ줿ǥե
			if (value == null) {
				result = def;
			} else {
				result = Integer.parseInt(value);
			}
		} catch (NumberFormatException e) {
			LogWriter.qwrite
			    ( "ERROR",
			      "invalid property value, ",
			      "property name = [", propName, "], ",
			      "value = [", value, "]" );

			// 顼Ϥơthrow
			System.err.println("ERROR [PropertyReader:getProperty], property = [" + propName + "]:" + e.getMessage());

			throw new NumberFormatException(e.getMessage());
		}
		return result;
	}

	/**
	 * ץѥƥե뤫Propertyͤޤ<BR>
	 * Property̾бͤĤʤϡ
	 * ǥեֵͤѤޤ<BR>
	 * ޤͤboolean˥㥹ȤǤʤäϡ
	 * false֤ޤ
	 *
	 * @param String Property̾
	 * @param boolean ǥե
	 */
	private static boolean getPropertyBoolean(String propName, String def) {
		String value = getProperty(propName, def);
		boolean result = Boolean.valueOf(def).booleanValue();
		// ͤ¸ߤʤȤꤵ줿ǥե
		if (value != null) {
			if ( ! value.equals( "true" )
			     && ! value.equals( "false" ) )
			{
				// 顼Ϥ롣
				LogWriter.qwrite
				    ( "ERROR",
				      "invalid property value, ",
				      "property name = [", propName, "], ",
				      "value = [", value, "]" );

				System.exit( 1 );
			}

			// ͤboolean˥㥹ȤǤʤȤϡ
			// ǥեȤfalse֤
			result = Boolean.valueOf(value).booleanValue();
		}

		return result;
	}

	/**
	 * ߻Υץѥƥե̾򼨤
	 */
	public static String getFileName() {
		if (prop == null) {
			try {
				initialize();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

		return cPropertyFile;
	}

	public static String getDefaultPropertyFile() {
		return DEFAULT_PROPERTY_FILE;
	}
}
