package daruma.util.test;

import org.junit.Test;
import org.junit.Before;
import junit.framework.TestCase;

import daruma.util.ISO8601DateFormat;
import java.util.Date;
import java.text.ParseException;


public class ISO8601DateFormatTest extends TestCase
{
	private	ISO8601DateFormat	f = null;

	@Before
	protected	void	setUp()
	{
		this.f = new ISO8601DateFormat();
	}

	@Test
	public	void	testCurrentTime() throws ParseException
	{
		Date	now = new Date( System.currentTimeMillis() );

		String	dateString = f.format( now );

		assertNotNull( dateString );

		Date	newNow = null;
		try
		{
			newNow = this.f.parse( dateString );
		}
		catch( ParseException  e )
		{
			throw e;
		}

		assertNotNull( newNow );
		assertEquals( now , newNow );
	}


	@Test
	public	void	testParseValidInput() throws ParseException
	{
		try
		{
			assertNotNull
			  ( this.f.parse( "2000-01-01T00:00:00.000+00:00" ) );

			assertNotNull
			  ( this.f.parse( "2000-01-01T00:00:00.000Z" ) );

			assertNotNull
			  ( this.f.parse( "2000-01-01T00:00:00.000Z" ) );

			Date  d1 = this.f.parse
					  ( "2000-01-01T00:00:00.000Z" );
			Date  d2 = this.f.parse
					  ( "2000-01-01T00:00:00.000Z" );
			Date  d3 = this.f.parse
					  ( "2000-01-01T09:00:00.000+09:00" );

			assertNotNull( d1 );
			assertNotNull( d2 );
			assertNotNull( d3 );
			assertEquals( d2 , d1 );
			assertEquals( d3 , d1 );
		}
		catch( ParseException  e )
		{
			throw e;
		}
	}


	@Test
	public	void	testParseInvalidInput() throws ParseException
	{
		try
		{
			assertNull
			  ( this.f.parse( "2000-01-01T00:00:00.000" ) );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}

		try
		{
			assertNull
			  ( this.f.parse( "2000-01-01T00:00:00.000" ) );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}

		try
		{
			assertNull
			  ( this.f.parse( "" ) );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}
	}

	@Test
	public	void	testOrigin() throws ParseException
	{
		Date origin = null;

		try
		{
			origin = this.f.parse( "1970-01-01T00:00:00.000Z" );
			assertNotNull( origin );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}

		assertEquals( 0L, origin.getTime() );
	}

	@Test
	public	void	testTimeZone() throws ParseException
	{
		Date origin_minus_1_hour = null;

		try
		{
			origin_minus_1_hour
			    = this.f.parse( "1970-01-01T00:00:00.000+01:00" );

			assertNotNull( origin_minus_1_hour );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}

		assertEquals( -1L * 60L * 60L * 1000L,
			      origin_minus_1_hour.getTime() );
	}

	@Test
	public	void	testMilliseconds() throws ParseException
	{
		Date origin_plus_123_milliseconds = null;

		try
		{
			origin_plus_123_milliseconds
			    = this.f.parse( "1970-01-01T00:00:00.123Z" );

			assertNotNull( origin_plus_123_milliseconds );
		}
		catch( ParseException  e )
		{
			assertTrue( true );
		}

		assertEquals( 123L, origin_plus_123_milliseconds.getTime() );
	}
}
