package daruma.wfs.filter;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.Node ;

import daruma.xml.DeclaredName ;
import daruma.xml.util.XMLParseErrorException;

import daruma.geometry.TransformationContext;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypeDefinition;

//======================================================================
/**
 * Filter ΡɤνҸǼ뤿Τݥ饹
 */
public abstract class PredicateDescription
{
    private StorageManager storage; 
    private TypeName typeName;
    private TypeDefinition type;
    private TransformationContext trans;

    protected DeclaredName tagName ;	/* match  Element  tagname 
					 * ϿΨ褯
					 * å뤿
					 * Lexicon ϿƤ
					 * ΤѤ롣
					 */

    protected List<PredicateDescription> children ; /// ҶΡ

    //--------------------------------------------------
    /**
     * 󥹥ȥ饯
     */
    public PredicateDescription(StorageManager  storage ,
				TypeName  typeName ,
				TypeDefinition  type ,
				TransformationContext trans )
    {
	this.storage = storage;
	this.typeName = typeName;
	this.type = type;
	this.trans = trans;
	this.children = new ArrayList<PredicateDescription>() ;
    }

    //--------------------------------------------------
    /**
     * SQL ؤѴ󥿡ե
     */
    public abstract String getSQLExpression();

    //--------------------------------------------------
    /**
     * storage ؤΥ
     */
    protected StorageManager getStorage()
    {
	return( this.storage );
    }

    //--------------------------------------------------
    /**
     * typeName ؤΥ
     */
    protected TypeName getTypeName()
    {
	return( this.typeName );
    }

    //--------------------------------------------------
    /**
     * typeDefinition ؤΥ
     */
    protected TypeDefinition getTypeDefinition()
    {
	return( this.type );
    }

    //--------------------------------------------------
    /**
     * CoordinateSystem ؤΥ
     */
    protected TransformationContext getTransformationContext()
    {
	return( this.trans );
    }

    //--------------------------------------------------
    /**
     * ҥΡɤؤɲ
     */
    public void addChild(PredicateDescription child) 
    {
	this.children.add(child) ;
    }

    //--------------------------------------------------
    /**
     * ҥΡɤ
     */
    public PredicateDescription getChild(int index)
    {
	return this.children.get(index) ;
    }

    //--------------------------------------------------
    /**
     * ҥΡɥꥹȤ
     */
    public List<PredicateDescription> getChildren()
    {
	return this.children ;
    }

    //--------------------------------------------------
    /**
     * ҥΡɤο
     */
    public int numberOfChildren()
    {
	return this.children.size() ;
    }

    //--------------------------------------------------
    /**
     * ܺ٥å
     * ʤɤΥå̩˹Ԥ2nd pass ν
     */
    abstract public boolean detailedCheck(Node feature) 
	throws XMLParseErrorException ;
}
