#!/usr/bin/perl
# DBSession.pm   ǡ١ȤäåǡΤʥ⥸塼
#    K.Nakahira, Last updated: 12/08/2002

package DBSession;
require 5.005;

use strict;
use DBI;
use MIME::Base64;
use Digest::MD5;
use Storable;

use vars qw(@ISA @EXPORT $VERSION);
$VERSION = '1.010';

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw();

# 
my $init = { dbtable => 'dbsession' };
my %type =
  ( Pg => { id => 'char(32)', ldate => 'timestamp', data => 'text' },
	mysql => { id => 'text', ldate => 'datetime', data => 'text' },
	Oracle => { id => 'long', ldate => 'date', data => 'long' },
  );
my %now =
  ( Pg => "'NOW'" );

=for html
<div class="header">
<h1>PgSession.pm</h1></div>

=for html
<div class="pod">

=head1 NAME

DBSession - ǡ١ȤäåǡΤʥ⥸塼

=head1 DESCRIPTION

httpd ꥯȤδ֤ǥåǡͭΤʥ⥸塼롣
ǡ˺ǽ򵭲Ƥꡢꤷͭ¤᤮ȥ
ݤ뤳ȤǤ롣
PostgreSQL б¾Υǡ١ˤбͽꡩ

  use DBSession;

  # TABLE  (Postgres ξ)
  $session = DBSession->new('dbi:Pg:dbname=mydbname', $user, $pass, undef,
                            noconnect => 1);
  $session->createtable(noexec => 1);

  # åID ɽ
  $session = DBSession->new('dbi:Pg:dbname=mydbname', $user, $pass);
  $id = $session->id;

  # ͤ񤭹
  $session->data(key1 => $value1, key2 => [ $foo, $bar ] );
  undef $session;

  # åǡɤ߹
  $session = DBSession->new('dbi:Pg:dbname=mydbname', $user, $pass, $id);
  $val = $session->data(key1);
  $data = $session->data();

  # å
  $session->remove;

  # Ǹι15ʬʤХå
  $session = DBSession->new('dbi:Pg:dbname=mydbname', $user, $pass, $id,
                            interval => '15 months');

  # åι򹹿
  $session->touch;

=head2 METHODS

=over 4

=item new ( DATASOURCE, USER, PASS [,ID [,OPTION]] )

  $session = DBSession->new($datasource, $user, $pass, $id);
  $session = DBSession->new($datasource, $user, $pass, $id, %opt);

DBSession֥Ȥ֤
$id ꤵƤϡå褦Ȥ롣
ǡ١ $id ʤ die ǽλ롣
$id ꤵƤʤСʥå
åǡ١롣

ǡ١Ȥ³˼Ԥꡢʥå󤬼Ǥʤϡ
die ǽλ롣

=cut

sub new {
  my ($class, $datasource, $user, $pass, $id, %opt) = @_;
  my $self;
  $self->{dbtable} = defined($opt{dbtable}) ? $opt{dbtable} : $init->{dbtable};
  die "The option 'dbtable' is invalid"
	if($self->{dbtable} !~ m/^[a-z]([a-z_]*[a-z])?$/);
  die if($id =~ m![^A-Fa-f0-9]!);

  # ǡ١μ
  if($datasource =~ m/^dbi:([^:]*):/) {
	$self->{kind} = $1 if(exists $type{$1});
  }
  die unless(exists $self->{kind});

  bless $self, $class;
  if($opt{noconnect}) {
	$self->{id} = $id;
	$self->{update} = 0;
	return $self;
  }

  $self->{dbh} = DBI->connect
	("$datasource", $user, $pass, { PrintError => 0, RaiseError => 1});

  $self->{data} = {};
  if(defined $id) {
	# ǡɤ߹
	my ($ldate, $data, $interval);
	$interval = "AND ldate > now() - INTERVAL '$opt{interval}'"
	  if($opt{interval});		# for Postgres
	eval {
	  ($ldate, $data) = $self->{dbh}->selectrow_array
		("SELECT ldate,data FROM $self->{dbtable} WHERE id = '$id' $interval");
	};
	die "Cannot find the session" unless(defined $ldate);
	$self->{ldate} = $ldate;

	$self->{data} = Storable::thaw(decode_base64($data)) if(defined $data);
  } else {
	# IDꡢǡ
	my $insert_sth = $self->{dbh}->prepare
	  ("INSERT INTO $self->{dbtable} (id, ldate) "
	   . "VALUES (?, $now{ $self->{kind} })");
	my $num = 5;
	while(1) {
	  $id = Digest::MD5::md5_hex(Digest::MD5::md5_hex(rand().time()));
	  my $rc;
	  eval { $rc = $insert_sth->execute($id) };
	  if($@ or not $rc) { die "Cannot create session" unless(--$num); }
	  else { last; }
	}
  }
  $self->{id} = $id;
  $self->{update} = 0;

  return $self;
}

=item DESTROY ( )

ǡ١Υǡ򹹿塢ǡ١Ȥ³Ǥ롣
ʤΤᡢ桼ϡκȤưǹԤʤƤ褤

=cut

sub DESTROY {
  my $self = shift;
  $self->update;
  $self->{dbh}->disconnect();
}

=item id ( )

  $id = $session->id();

åID롣

=cut

sub id {
  my $self = shift;
  $self->{id};
}

=item ldate ( )

  $ldate = $session->ldate();

åǡǸ˹롣

=cut

sub ldate {
  my $self = shift;
  $self->{ldate};
}

=item data ( KEY or DATA )

  $data = $session->data();
  $value = $session->data($key);
  $session->data(%data);

åǡ˥롣
0Ĥξϡǡͤɤ߹ࡣ
1Ĥξϡǡб륭ͤɤ߹ࡣ
2ʾζġ̾ϥϥåˤξϡ
ǡб륭ͤ롣
3ʾδĤξϡdie ǽλ롣

=cut

sub data {
  my $self = shift;
  return $self->{data} if(@_ == 0);
  return $self->{data}{ $_[0] } if(@_ == 1);
  die if(@_ % 2);
  $self->{update} ||= 1;
  while(@_) {
	my $key = shift;
	my $value = shift;
	$self->{data}{$key} = $value;
  }
}

=item read ( KEY or DATA )

  $data = $session->read();
  ($value1, $value2) = $session->read($key1, $key2);

åǡɤ߹ࡣ
0Ĥξϡǡͤɤ߹ࡣ
ϡν֤Ǥ줾б륭֤ͤ
ƤӽФΥƥȤ顼ͤƤȤ
κǽǤ֤
ʽäơ0,1Ĥξϡdata ᥽åɤƱƯ򤹤롣

=cut

sub read {
  my $self = shift;
  return $self->{data} if(@_ == 0);
  my $ret = [ ];
  foreach my $key (@_) {
	push(@$ret, $self->{data}{$key});
  }
  return wantarray ? @$ret : $ret->[0];
}

=item remove ( )

  $session->remove();

DELETE ʸ¹Ԥơåǡ١롣

=cut

sub remove {
  my ($self) = @_;

  $self->{dbh}->do
	("DELETE FROM $self->{dbtable} WHERE id = '$self->{id}'");
  $self->{dbh}->disconnect();
  undef $self;
}

=item touch ( )

  $session->touch();

ldate 򹹿롣

=cut

sub touch {
  my ($self) = @_;

  unless(defined $self->{touch_sth}) {
	$self->{touch_sth} =
	  $self->{dbh}->prepare
		("UPDATE $self->{dbtable} SET ldate = $now{ $self->{kind} } "
		 . "WHERE id = '$self->{id}'");
  }
  $self->{touch_sth}->execute;
}

=item update ( )

  $session->update();

ǡ򥷥ꥢ饤塢
UPDATE ʸ¹Ԥƥǡǡ١˳Ǽ롣

=cut

sub update {
  my ($self) = @_;

  return undef unless($self->{update});
  my $data = encode_base64(Storable::nfreeze($self->{data}));

  unless(defined $self->{update_sth}) {
	$self->{update_sth} =
	  $self->{dbh}->prepare
		("UPDATE $self->{dbtable} SET ldate = $now{ $self->{kind} }, data = ? "
		 . "WHERE id = '$self->{id}'");
  }
  $self->{update_sth}->execute($data);
  $self->{update} = 0;
  return 1;
}

=item createtable ( [OPTION] )

  $sql = $session->createtable();
  $sql = $session->createtable(noexec => 1);

TABLE 롣ޤTABLE 뤿 SQL ʸ֤
C<opt::noexec>  true ΤȤ CREATE TABLE ʸμ¹ԤϹԤʤ

=cut

sub createtable {
  my ($self, %opt) = @_;
  my $sql;
  $sql  = "CREATE TABLE $self->{dbtable} (\n";
  $sql .= "  id $type{ $self->{kind} }{id} UNIQUE,\n";
  $sql .= "  ldate $type{ $self->{kind} }{ldate},\n";
  $sql .= "  data $type{ $self->{kind} }{data} )";
  $self->{dbh}->do($sql) or die unless($opt{noexec});
  return $sql . ";\n";
}

=item droptable ( )

  $sql = $session->droptable();
  $sql = $session->droptable(noexec => 1);

TABLE 롣ޤ뤿 SQL ʸ֤
C<opt::noexec>  true ΤȤ DROP TABLE ʸμ¹ԤϹԤʤ

=cut

sub droptable {
  my ($self, %opt) = @_;
  my $sql;
  $sql  = "DROP TABLE $self->{dbtable}";
  $self->{dbh}->do($sql) or die unless($opt{noexec});
  return $sql . ";\n";
}

1;
__END__

=back

=head1 SEE ALSO

F<DBI>, F<MIME::Base64>, F<Digest::MD5>, F<Storable>

=head1 COPYRIGHT

(c) Kenji Nakahira <nakahira@bioele.nuee.nagoya-u.ac.jp>

This library is free software; you can redistribute it
and/or modify it under the same terms as Perl itself.

=for html
</div>

=cut
