#!/bin/sh
# chconf.sh   եʤɤѤ
#    K.Nakahira, Last updated: 12/29/2002

# ΥץȤǤϡ󥹥ȡΥǥ쥯ȥ˴ؤ
# ŪѹԤޤ

if [ "$1" = "" ]; then
	echo "Usage: $0 <conffile>"
	exit 1
fi

# եɤ߹
if [ -f "$1" ]; then
	. $1
else
	echo "Cannot open '$1'"
	exit 1
fi

MAKEFILE="$BASEDIR/Makefile"
BASEFILE="$BASEDIR/base.conf"
CONFFILE="$BASEDIR/data.conf"
AUTHINIT="$BASEDIR/auth_init.sql"
DATE=`date '+%m%d%H%M%S'`

check() {
	echo -n "$1"
	read ans
	if [ "$ans" != "yes" -a "$ans" != "y" ]; then return 1; fi
	return 0
}

# Makefile Խ
setup_makefile() {
	MAKEFILE_ORIG="$MAKEFILE.org-$DATE"
	echo "$MAKEFILE => $MAKEFILE_ORIG"
	cp $MAKEFILE $MAKEFILE_ORIG

	CMD="s!/usr/local/DBIPgSystem/samples/cv!$BASEDIR!; "
	perl -pe "$CMD" "$MAKEFILE_ORIG" > "$MAKEFILE"
}

# եԽ
setup_baseconf() {
	BASEFILE_ORIG="$BASEFILE.org-$DATE"
	echo "$BASEFILE => $BASEFILE_ORIG"
	cp $BASEFILE $BASEFILE_ORIG

	CMD="s!/usr/local/DBIPgSystem/samples/cv!$BASEDIR!; "
	CMD=$CMD"s!/usr/local/DBIPgSystem/public_html/cgi-bin/cv_staff!" \
		CMD=$CMD"$CGIDIR_STF!; "
	CMD=$CMD"s!/usr/local/DBIPgSystem/public_html/cgi-bin/cv_pub!" \
		CMD=$CMD"$CGIDIR_PUB!; "
	CMD=$CMD"s!(base->{nph} =) [01]!\$1 $NPH!; "
	CMD=$CMD"s!(base->{suexec} =) [01]!\$1 $SUEXEC!; "
	perl -pe "$CMD" "$BASEFILE_ORIG" > "$BASEFILE"
}

# ǡեԽ
setup_dataconf() {
	CONFFILE_ORIG="$CONFFILE.org-$DATE"
	echo "$CONFFILE => $CONFFILE_ORIG"
	cp $CONFFILE $CONFFILE_ORIG

	CMD="s!(maintenance =>) 0!\$1 1!; "
	CMD=$CMD"s!(basedir =>) '/usr/local/DBIPgSystem/samples/cv'!" \
		CMD=$CMD"\$1 '$BASEDIR'!; "
	CMD=$CMD"s!(staff =>) '/cgi-bin/cv_staff'!\$1 '$BASEURI_STF'!; "
	CMD=$CMD"s!(pub =>) '/cgi-bin/cv_pub'!\$1 '$BASEURI_PUB'!; "
	CMD=$CMD"s!(mailfrom =>) '.*?'!\$1 '$MAILFROM'!; "
	CMD=$CMD"s!(mailto =>) '.*?'!\$1 => '$MAILTO'!; "
	CMD=$CMD"s!(staff =>) '/usr/local/DBIPgSystem/public_html/cv/staff!" \
		CMD=$CMD"\$1 '$EXPT_STF!; "
	CMD=$CMD"s!(pub =>) '/usr/local/DBIPgSystem/public_html/cv/pub!" \
		CMD=$CMD"\$1 '$EXPT_PUB!; "
	CMD=$CMD"s!(staff =>) '/cv/staff'!\$1 '$EXPT_URI_STF'!; "
	CMD=$CMD"s!(pub =>) '/cv/pub'!\$1 '$EXPT_URI_PUB'!; "
	CMD=$CMD"s!(my \\\$uri =) \"http://localhost/cgi-bin/cv_\\\$group\"!" \
		CMD=$CMD"\$1 \"$INSERT_MAIL_URI\"!; "
	CMD=$CMD"s!(dir =>) '/usr/local/DBIPgSystem/public_html/cv/img'!" \
		CMD=$CMD"\$1 '$FT_DIR'!; "
	CMD=$CMD"s!(pooldir =>) '/usr/local/DBIPgSystem/samples/cv/pool'!" \
		CMD=$CMD"\$1 '$FT_PDIR'!; "
	CMD=$CMD"s!(tmpdir =>) '/usr/local/DBIPgSystem/public_html/cv/tmpimg'!" \
		CMD=$CMD"\$1 '$FT_TDIR'!; "
	[ -n "$DB_DATA_SOURCE" ] && \
		CMD=$CMD"s!(data_source =>) 'dbname=[^']*'!\$1 '$DB_DATA_SOURCE'!; "
	[ -n "$DB_USERNAME" ] && \
		CMD=$CMD"s!(username =>) 'dbipg'!\$1 '$DB_USERNAME'!; "
	[ -n "$DB_PASSWD" ] && \
		CMD=$CMD"s!(passwd =>) 'dbipg_passwd'!\$1 '$DB_PASSWD'!; "
	CMD=$CMD"s!(fileuri =>) '/cv/img'!\$1 '$FT_URI'!; "
	CMD=$CMD"s!(tmpfileuri =>) '/cv/tmpimg'!\$1 '$FT_TURI'!; "
	CMD=$CMD"s!(identify =>) '[^']*'!\$1 '$IDENTIFY'!; "
	CMD=$CMD"s!(convert =>) '[^']*'!\$1 '$CONVERT'!; "
	CMD=$CMD"s!(tifftopnm =>) '[^']*'!\$1 '$TIFFTOPNM'!; "
	CMD=$CMD"s!(pnmtojpeg =>) '[^']*'!\$1 '$PNMTOJPEG'!; "
	CMD=$CMD"s!(cp =>) '[^']*'!\$1 '$CP'!; "
	perl -pe "$CMD" "$CONFFILE_ORIG" > "$CONFFILE"
}

# $AUTHINIT Խ
setup_authinit() {
	AUTHINIT_ORIG="$AUTHINIT.org-$DATE"
	echo "$AUTHINIT => $AUTHINIT_ORIG"
	cp $AUTHINIT $AUTHINIT_ORIG

	CMD="s!'admin'!'$MAILTO'!; "
	perl -pe "$CMD" "$AUTHINIT_ORIG" > "$AUTHINIT"
}

echo "*** Makefile ***"
check "Would you like to fix $MAKEFILE (yes/no) ? " \
	&& setup_makefile || echo "Aborted."
echo "*** $BASEFILE ***"
check "Would you like to fix the config file '$BASEFILE' (yes/no) ? " \
	&& setup_baseconf || echo "Aborted."
echo "*** $CONFFILE ***"
check "Would you like to fix the config file '$CONFFILE' (yes/no) ? " \
	&& setup_dataconf || echo "Aborted."
echo "*** $AUTHINIT ***"
check "Would you like to fix the config file '$AUTHINIT' (yes/no) ? " \
	&& setup_authinit || echo "Aborted."
exit

