/*
 * 쐬: 2005/03/28 쌠: Copyright (c) 2005 ZIGEN CZXFCommon Public License - v 1.0 Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core.rule;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.Types;

import zigen.plugin.db.DbPlugin;

/**
 * MySQLMappingFactory.java.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/11/26 ZIGEN create.
 * 
 */
public class MySQLMappingFactory extends DefaultMappingFactory implements IMappingFactory {

	MySQLMappingFactory(boolean convertUnicode) {
		super(convertUnicode);
	}

	protected void setBinary(PreparedStatement pst, int icol, Object value) throws Exception {
		if (value == null) {
			pst.setNull(icol, Types.BLOB);
			return;

		} else {
			int size = 0;
			try {
				if (value instanceof File) {
					File file = (File) value;
					size = (int) file.length();
					pst.setBinaryStream(icol, new FileInputStream(file), (int) size);

				} else if (value instanceof byte[]) {
					byte[] bytes = (byte[]) value;
					size = bytes.length;
					pst.setBinaryStream(icol, new ByteArrayInputStream(bytes), (int) size);

				} else if (value instanceof String) {
					String str = (String) value;
					if (nullSymbol.equals(str)) {
						pst.setNull(icol, Types.BLOB);
						return;
					} else {
						byte[] bytes = str.getBytes();
						size = bytes.length;
						pst.setBinaryStream(icol, new ByteArrayInputStream(bytes), (int) size);
					}
				}

			} catch (Exception e) {
				DbPlugin.log(e);

			}

		}
	}

}