/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.SWT;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.editors.ITableViewEditor;

/**
 * TableViewEditorActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/12 ZIGEN create.
 * 
 */
public abstract class TableViewEditorAction extends Action implements Runnable {

	protected ITableViewEditor editor;

	protected IDBConfig config;

	// DisposéANULLݒ肳
	public void setActiveEditor(ITableViewEditor target) {
		if (target != null) {
			editor = target;
			config = target.getDBConfig();
		} else {
			editor = null;
			config = null;
		}
	}

	public void setImage(int operation) {
		String imageName = null;

		switch (operation) {
		// case ITextOperationTarget.UNDO:
		// imageName = ISharedImages.IMG_TOOL_UNDO;
		// setText("ɖ߂(&U)");
		// setAccelerator(SWT.CTRL | 'Z');
		// break;
		// case ITextOperationTarget.REDO:
		// imageName = ISharedImages.IMG_TOOL_REDO;
		// setText("蒼(&R)");
		// setAccelerator(SWT.CTRL | 'Y');
		// break;
		// case ITextOperationTarget.CUT:
		// imageName = ISharedImages.IMG_TOOL_CUT;
		// setText("؂(&T)");
		// setAccelerator(SWT.CTRL | 'X');
		// break;
		case ITextOperationTarget.COPY:
			imageName = ISharedImages.IMG_TOOL_COPY;
			setText(Messages.getString("TableViewEditorAction.CopyRecord")); //$NON-NLS-1$
			setAccelerator(SWT.CTRL | 'C');
			break;
		case ITextOperationTarget.PASTE:
			imageName = ISharedImages.IMG_TOOL_PASTE;
			setText(Messages.getString("TableViewEditorAction.PasteRecord")); //$NON-NLS-1$
			setAccelerator(SWT.CTRL | 'V');
			break;
		case ITextOperationTarget.DELETE:
			imageName = org.eclipse.ui.ISharedImages.IMG_TOOL_DELETE;
			setText(Messages.getString("TableViewEditorAction.DeleteRecord")); //$NON-NLS-1$
			setAccelerator(SWT.DEL);
			break;
		case ITextOperationTarget.SELECT_ALL:
			setText(Messages.getString("TableViewEditorAction.SelectAll")); //$NON-NLS-1$
			setAccelerator(SWT.CTRL | 'A');
			imageName = null;
			break;
		default:
			break;
		}

		if (imageName != null) {
			setImageDescriptor(imageName);
		}

	}

	protected void setImageDescriptor(String imageName) {
		this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName));
	}
}
