/*
 * 쐬: 2005/04/07
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;

import zigen.plugin.db.preference.SQLEditorPreferencePage;

/**
 * SQLKeywordScannerNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/04/07 ZIGEN create.
 *        [002] 2005/05/29 ZIGEN SQLL[[h̃V^bNXnCCg̏C.
 * 
 */
public class SQLKeywordScanner extends RuleBasedScanner {

	static class WordDetector implements IWordDetector {
		public boolean isWordPart(char c) {
			return Character.isJavaIdentifierPart(c);
		}

		public boolean isWordStart(char c) {
			return Character.isJavaIdentifierStart(c);
		}
	}

	static class WhitespaceDetector implements IWhitespaceDetector {
		public boolean isWhitespace(char character) {
			return Character.isWhitespace(character);
		}
	}

	private ColorManager colorManager;

	public SQLKeywordScanner(ColorManager colorManager) {
		this.colorManager = colorManager;
		initialize();
	}

	public void initialize() {
		// L[[h
		String[] keywords = getSQL_Keyword();
		IRule[] rules = new IRule[2];
		IToken other = new Token(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_DEFAULT)));
		IToken keyword = new Token(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_KEYWORD), null, SWT.BOLD));

		WordRule wordRule = new WordRule(new WordDetector(), other);
		for (int i = 0; i < keywords.length; i++) {
			wordRule.addWord(keywords[i], keyword);
		}
		/*
		 * // add IToken other2 = new Token(new
		 * TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_DEFAULT)));
		 * WordRule wordRule2 = new WordRule(new IWordDetector() { public
		 * boolean isWordStart(char c) { return c == '(' || c == ')' || c == ',' ||
		 * c == '.' || c == '*' || c == '/' || c == '+' || c == '-' || c == '|' ||
		 * c == '<' || c == '>' || c == '=' || c == '!';
		 *  }
		 * 
		 * public boolean isWordPart(char c) { return
		 * !Character.isWhitespace(c);
		 *  } }, other2); // add end
		 */;
		rules[0] = wordRule;
		// rules[1] = wordRule2;
		rules[1] = new WhitespaceRule(new WhitespaceDetector());
		// rules[2] = new WhitespaceRule(new WhitespaceDetector());

		setRules(rules);

	}

	/**
	 * L[[hXLp̎擾 SQLL[[h̏A啶̗擾
	 * 
	 * @return
	 */
	private String[] getSQL_Keyword() {
		String[] keys = new String[SQLKeywords.length * 2];
		int keyIndex = 0;
		for (int i = 0; i < SQLKeywords.length; i++) {
			keyIndex = i * 2;
			keys[keyIndex] = SQLKeywords[i];
			keys[keyIndex + 1] = SQLKeywords[i].toLowerCase();

		}
		return keys;
	}

	// F\P
	public static final String[] SQLKeywords = {
			"ADD", //$NON-NLS-1$
			"ALL", //$NON-NLS-1$
			"ALTER", //$NON-NLS-1$
			"AND", //$NON-NLS-1$
			"AS", //$NON-NLS-1$
			"ASC", //$NON-NLS-1$
			"BETWEEN", //$NON-NLS-1$
			"BEGIN", //$NON-NLS-1$
			"BY", //$NON-NLS-1$
			"CASCADE", //$NON-NLS-1$
			"CASE", //$NON-NLS-1$
			"COLUMN", //$NON-NLS-1$
			"COMMENT", //$NON-NLS-1$
			"COMMIT", //$NON-NLS-1$
			"CONSTRAINT", //$NON-NLS-1$
			"CREATE", //$NON-NLS-1$
			"DATE", //$NON-NLS-1$
			"DEFAULT", //$NON-NLS-1$
			"DELETE", //$NON-NLS-1$
			"DESC", //$NON-NLS-1$
			"DISTINCT", //$NON-NLS-1$
			"DROP", //$NON-NLS-1$
			"END", //$NON-NLS-1$
			"ELSE", //$NON-NLS-1$
			"END", //$NON-NLS-1$
			"ESCAPE", //$NON-NLS-1$
			"EXISTS", //$NON-NLS-1$
			"FOREIGN", //$NON-NLS-1$
			"FROM", //$NON-NLS-1$
			"FUNCTION", //$NON-NLS-1$
			"GROUP", //$NON-NLS-1$
			"HAVING", //$NON-NLS-1$
			"IF", //$NON-NLS-1$
			"IN", //$NON-NLS-1$
			"INDEX", //$NON-NLS-1$
			"INNER", //$NON-NLS-1$
			"INSERT", //$NON-NLS-1$
			"INTO", //$NON-NLS-1$
			"IS", //$NON-NLS-1$
			"JOIN", //$NON-NLS-1$
			"KEY", //$NON-NLS-1$
			"LEFT", //$NON-NLS-1$
			"LIKE", //$NON-NLS-1$
			"MATCH", //$NON-NLS-1$
			"NOT", //$NON-NLS-1$
			"NULL", //$NON-NLS-1$
			"ON", //$NON-NLS-1$
			"OPTION", //$NON-NLS-1$
			"OR", //$NON-NLS-1$
			"ORDER", //$NON-NLS-1$
			"OUTER", //$NON-NLS-1$
			"PRIMARY", //$NON-NLS-1$
			"PROCEDURE", //$NON-NLS-1$
			"RENAME", //$NON-NLS-1$
			"RETURN", //$NON-NLS-1$
			"RIGHT", //$NON-NLS-1$
			"ROLLBACK", //$NON-NLS-1$
			"ROWS", //$NON-NLS-1$
			"SCHEMA", //$NON-NLS-1$
			"SELECT", //$NON-NLS-1$
			"SET", //$NON-NLS-1$
			"SHOW", //$NON-NLS-1$
			"SYSDATE", //$NON-NLS-1$
			"TABLE", //$NON-NLS-1$
			"TEMPORARY", //$NON-NLS-1$
			"TIME", //$NON-NLS-1$
			"TIMESTAMP", //$NON-NLS-1$
			"TRUNCATE", //$NON-NLS-1$
			"TYPE", //$NON-NLS-1$
			"UNION", //$NON-NLS-1$
			"UNIQUE", //$NON-NLS-1$
			"UPDATE", //$NON-NLS-1$
			"VALUES", //$NON-NLS-1$
			"VIEW", //$NON-NLS-1$
			"WHERE", //$NON-NLS-1$
			"WHEN",	//$NON-NLS-1$
			"WITH" //$NON-NLS-1$
	};

}
