/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.views.SQLExecuteView;

/**
 * CommitActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/12 ZIGEN create.
 *        [002] 2005/05/29 ZIGEN R~bg̃bZ[WύX.
 */
public class CommitAction extends Action implements Runnable {


	private SQLExecuteView view;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public CommitAction(SQLExecuteView view) {
		this.setText(Messages.getString("CommitAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("CommitAction.1")); //$NON-NLS-1$
		this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_COMMIT));

		this.view = view;

	}

	/**
	 * Actions̏
	 */
	public void run() {
		try {
			// SQLsr[IDBConfig擾

			Transaction trans = Transaction.getInstance(view.getConfig());

			if (!trans.isConneting()) {
				DbPlugin.getDefault().showWaringMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
				return;
			}

			int transCount = trans.getTransactionCount();

			trans.commit();
			view.setStatusMessage(createMessage(transCount));
			// DbPlugin.getDefault().showInformationMessage(getMessage(transCount));

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

	private String createMessage(int count) {
		// <!-- [002] 폜 ZIGEN 2005/05/29
		// return count + "AR~bg܂";
		return count + Messages.getString("CommitAction.3"); //$NON-NLS-1$
		// [002] 폜 ZIGEN 2005/05/29 -->
		// return "R~bg";

	}

}
