package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class AddPrimaryKeyInvoker extends AbstractSQLInvoker {


	private static String TITLE = Messages.getString("AddPrimaryKeyInvoker.0"); //$NON-NLS-1$

	String constraintName;

	Column[] columns;

	public AddPrimaryKeyInvoker(ITable table, String constraintName, Column[] columns) {
		super(TITLE, table);
		this.constraintName = constraintName;
		this.columns = columns;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createCreateConstraintPKDDL(constraintName, columns);
		return new String[] {
			sql
		};
	}

}