/*
 * 쐬: 2006/02/08
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.views.SQLExecuteView;

/**
 * AbstractOpenEditorJobNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/02/08 ZIGEN create.
 * 
 */
public abstract class AbstractJob extends Job {

	protected TimeWatcher tw = new TimeWatcher();

	protected IPreferenceStore store;

	public AbstractJob(String msg) {
		super(msg); // Titlew
		store = DbPlugin.getDefault().getPreferenceStore();
	}

	protected void start() {
//		log.debug("start job:" + super.getName());
		setProperty(IProgressConstants.ICON_PROPERTY, null);
		tw.start();
	}

	protected void stop() {
//		log.debug("stop job:" + super.getName());
		tw.stop();
	}

	protected String getTotalTime() {
		String time = tw.getTotalTime();
//		log.debug("response job:" + time);
		return time;
	}

	protected final void showResults(Runnable action) {
		Display.getDefault().asyncExec(action);
	}

	protected final void showWarningMessage(String message) {
		Display.getDefault().asyncExec(new ShowMessageAction(message));
	}

	protected final void showErrorMessage(String message, Throwable e) {
		Display.getDefault().asyncExec(new ShowErrorMessageAction(message, e));
	}

	// protected final void updateResponseTime(String responseTime) {
	// Display.getDefault().asyncExec(new
	// UpdateResponseTimeAction(responseTime));
	// }

	protected final void updateMessage(IDBConfig config, String message, String secondaryId) {
		Display.getDefault().asyncExec((Runnable) new UpdateStatusMessageAction(message, secondaryId));
	}

	// protected boolean isModal(Job job) {
	// Boolean isModal = (Boolean)
	// job.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
	// if (isModal == null)
	// return true; // _CAOꍇ͌ʂ𑦕\邽trueɂ
	// return isModal.booleanValue();
	// }
	//
	// protected void showResults(Runnable action) {
	// if (isModal(this)) {
	// Display.getDefault().asyncExec(action);
	// } else {
	// setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
	// setProperty(IProgressConstants.ACTION_PROPERTY, action);
	// }
	// }

	public class ShowMessageAction implements Runnable {
		String msg = null;

		public ShowMessageAction(String msg) {
			this.msg = msg;
		}

		public void run() {
			try {
				DbPlugin.getDefault().showWaringMessage(msg);
			} catch (Exception e) {
				DbPlugin.log(e);
			}
		}
	}

	public class ShowErrorMessageAction implements Runnable {
		Throwable e;

		String msg;

		public ShowErrorMessageAction(String msg, Throwable e) {
			this.msg = msg;
			this.e = e;
		}

		public void run() {
			try {
				DbPlugin.getDefault().showErrorDialog(e);

			} catch (Exception e) {
				DbPlugin.log(e);
			}
		}
	}

	// public class UpdateResponseTimeAction implements Runnable {
	// String msg = null;
	// public UpdateResponseTimeAction(String msg) {
	// this.msg = msg;
	// }
	// public void run() {
	// try {
	// IViewPart part = DbPlugin.findView(DbPluginConstant.VIEW_ID_SQLExecute);
	// // if (part instanceof SQLExecuteView) {
	// // SQLExecuteView view = (SQLExecuteView) part;
	// // view.setResponseTime(msg);
	// // }
	// SQLExecuteView view = DbPlugin.getDefault().getActiveSQLExecuteView();
	// if (view != null) {
	// view.setResponseTime(msg);
	// }
	//
	// } catch (Exception e) {
	// DbPlugin.log(e);
	// }
	//
	// }
	//
	// }

	public class UpdateStatusMessageAction implements Runnable {

		private String message;

		private String secondaryId;

		public UpdateStatusMessageAction(String message, String secondaryId) {
			this.message = message;
			this.secondaryId = secondaryId;
		}

		public void run() {
			try {
				SQLExecuteView view = null;
				if (secondaryId == null) {
					view = (SQLExecuteView) DbPlugin.findView(DbPluginConstant.VIEW_ID_SQLExecute);
				} else {
					view = (SQLExecuteView) DbPlugin.findView(DbPluginConstant.VIEW_ID_SQLExecute, secondaryId);
				}
				if (view != null) {
					view.setStatusMessage(message);
				}

			} catch (Exception e) {
				DbPlugin.log(e);
			}

		}

	}
}
