/*
 * 쐬: 2005/03/16
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */

package zigen.plugin.db.core;

import java.util.Properties;

/**
 * IDBConfigNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/16 ZIGEN create.
 * 
 */
public interface IDBConfig {

	public Properties getProperties();

	public String getDbName();

	public String getDriverName();

	public String getUrl();

	public String getUserId();

	public String getPassword();

	public String getSchema();

	public String[] getClassPaths();

	public String getCharset();

	public boolean isConvertUnicode();

	public int getDbType(); // DBp

	public String getDriverVersion();

	public boolean isAutoCommit();

	public boolean isOnlyDefaultSchema();

	// public String getNullSymbol();

	public void setDbName(String dbName);

	public void setDriverName(String driverName);

	public void setUrl(String url);

	public void setUserId(String userid);

	public void setPassword(String password);

	public void setSchema(String schema);

	public void setClassPaths(String[] classPaths);

	public void setCharset(String charset);

	public void setConvertUnicode(boolean b);

	public void setDriverVersion(String version);

	public void setAutoCommit(boolean b);

	public void setOnlyDefaultSchema(boolean b);

	// public void setNullSymbol(String nullSymbol);

	public void setJdbcType(int type);

	public int getJdbcType();

	public boolean isSavePassword();

	public void setSavePassword(boolean b);

	// for Symfoware
	public boolean isNoLockMode();

	public void setNoLockMode(boolean b);
	
	public Object clone();
}
