/*
 * 쐬: 2005/05/31
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.DefaultXmlManager;
import zigen.plugin.db.preference.PreferencePage;

public class SQLHistoryManager extends DefaultXmlManager {

	private int maxSize = 100;

	private List history = null;

	int currentPosition = 0;

	private IPreferenceStore preferenceStore;

	public SQLHistoryManager(IPath path) {
		super(path, DbPluginConstant.FN_SQL_HISTORY);

		this.preferenceStore = DbPlugin.getDefault().getPreferenceStore();

		history = load();
		if (history == null) {
			history = new ArrayList();
			history.add(new SQLHistory(true)); // blank
		}

	}

	public List load() {
		try {
			Object obj = super.loadXml();
			if (obj instanceof List) {
				history = (List) obj;
				// ݂̈ʒuݒ
				if (history.size() > 0) {
					currentPosition = history.size();
				}
				// SQLǉ(ɂ͕ۑȂj
				//history.add(currentPosition, new SQLHistory(true));
				history.add(new SQLHistory(true));
				
				// \[g
				Collections.sort(history, new SQLHistorySorter());

				return history;
			}
		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
		return null;
	}

	public void save() {
		try {
			// 󔒂͎菜
			for (Iterator iter = history.iterator(); iter.hasNext();) {
				SQLHistory sql = (SQLHistory) iter.next();
				if (sql.isBlank()) {
					iter.remove();
				}
			}
			super.saveXml(history);
		} catch (IOException e) {
			DbPlugin.log(e);
		}

	}

//	public static void main(String[] args){
//		
//		ArrayList history = new ArrayList();
//		history.add(new SQLHistory(true)); // blank
//		history.add(new SQLHistory(null, "1"));
//		history.add(new SQLHistory(true)); // blank
//		history.add(new SQLHistory(null, "2"));
//		history.add(new SQLHistory(true)); // blank
//		history.add(new SQLHistory(null, "3"));
//		
//		Collections.sort(history, new SQLHistorySorter());
//		for (int i = 0; i < history.size(); i++) {
//			System.out.println("@>" + ((SQLHistory)history.get(i)).getSql());
//		}
//		
//		System.out.println("");
//		Collections.sort(history, new SQLHistorySorter());
//		for (int i = 0; i < history.size(); i++) {
//			System.out.println("@>" + ((SQLHistory)history.get(i)).getSql());
//		}
//	}
	
	
	public List getHistory() {
		return this.history;
	}

	public int getHistoryCount() {
		return history.size();
	}

	public void clearHistory() {
		history = new ArrayList();
		currentPosition = 0;

	}

	public void removeOverHistory() {
		try {
			this.maxSize = preferenceStore.getInt(PreferencePage.P_MAX_HISTORY);
			while (history.size()-1 > maxSize) { // 󔒗pl
				history.remove(0);
				currentPosition--; // 炵ʒu--
			}
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
		
	}

	private boolean isSameHistory(String sql, int position) {
		if (position >= 0) {
			SQLHistory his = (SQLHistory) history.get(position);
			String hSql = SQLFormatter.unformat(his.getSql());
			String uSql = SQLFormatter.unformat(sql);
			if (uSql.equals(hSql)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}

	}

	public boolean addHistory(SQLHistory his) {
		boolean isAdd = false;
		String sql = his.getSql();
		SQLHistory current = currentHistory();
		if (!isSameHistory(sql, currentPosition)) {
			history.add(his); // Ō̂POɂ
			currentPosition = history.size()-2; // JgŌォPOɂ
			isAdd = true;
		}
		Collections.sort(history, new SQLHistorySorter());
		
		// ő吔𒴂͍폜
		removeOverHistory();
		return isAdd;
	}

	public void remove(SQLHistory sqlHistory) {
		history.remove(sqlHistory);
		if(currentPosition > 0){currentPosition--;}
	}

	// ݂̗擾
	public SQLHistory currentHistory() {
		return (history.size() == 0) ? null : (SQLHistory) history.get(currentPosition);

	}

	// O̗擾
	public SQLHistory prevHisotry() {
		return (currentPosition <= 0) ? null : (SQLHistory) history.get(--currentPosition);
	}

	// ̗擾
	public SQLHistory nextHisotry() {
		return (currentPosition == history.size() - 1) ? null : (SQLHistory) history.get(++currentPosition);
	}

	// O̗邩ǂ
	public boolean hasPrevHistory() {
		return (currentPosition >= 1);
	}

	// ̗邩ǂ
	public boolean hasNextHistory() {
		return (history.size() - 1 > currentPosition);
	}

	// fobNp
	public int getCurrentPosition() {
		return currentPosition;
	}
	
	public void modifyCurrentPosition(SQLHistory target){
		for (int i = history.size()-1; i >= 0; i--) {
			SQLHistory sql = (SQLHistory) history.get(i);
			if(sql.equals(target)){
				currentPosition = i;
				return;
			}
		}

	}

}
