/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.ui.views.SQLExecuteView;

/**
 * CommitActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/12 ZIGEN create.
 * 
 */
public class NextSQLExecAction extends Action implements Runnable {
	private SQLExecuteView view;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public NextSQLExecAction(SQLExecuteView view) {
		this.setText(Messages.getString("NextSQLExecAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("NextSQLExecAction.1")); //$NON-NLS-1$
		this.setActionDefinitionId("zigen.plugin.SQLNextCommand"); //$NON-NLS-1$
		this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor(DbPlugin.IMG_CODE_FORWARD));
		// this.setDisabledImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor(DbPluginConstant.IMG_CODE_E_FORWARD));
		this.view = view;
	}

	/**
	 * Actions̏
	 */
	public void run() {

		SQLHistory history = DbPlugin.getDefault().getHistoryManager().nextHisotry();
		if (history != null) {
			view.getSqlViewer().getDocument().set(history.getSql());
			view.getSqlViewer().setSelectedRange(history.getSql().length(), 0);
			view.getSqlViewer().invalidateTextPresentation(); // eLXgGfB^ĕ`
		} else {
			view.getSqlViewer().getDocument().set(""); //$NON-NLS-1$
		}
		view.updateHistoryButton();

	}

}
