package zigen.plugin.db.ui.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.properties.DBPropertyPage;

public class ProjectUtil {

	public static String getDBConfigName(IProject project) {
		String dbName = null;
		try {
			if(project.isOpen()){
				dbName = project.getPersistentProperty(new QualifiedName(DBPropertyPage.QUALIFIER, DBPropertyPage.SELECTED_DB));
			}else{
				; // ProjectĂ邽߁A܂
			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}
		return dbName;
	}
	
	public static IDBConfig getDBConfig(IProject project) {
		String dbName = getDBConfigName(project);
		if (dbName != null) {
			return DBConfigManager.getDBConfig(dbName);
		} else {
			return null;
		}
	}

}
