/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import zigen.plugin.db.DbPlugin;

/**
 * CSVPreferencePageNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/10 ZIGEN create.
 * 
 */
public class CSVPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
	public static final String P_ENCODING = "CSVPreferencePage.Encoding"; //$NON-NLS-1$

	public static String[] encordes = {
			"MS932", //$NON-NLS-1$
			"ISO-8859-1", //$NON-NLS-1$
			"ISO2022JP", //$NON-NLS-1$
			"JIS", //$NON-NLS-1$
			"Shift-JIS", //$NON-NLS-1$
			"US-ASCII", //$NON-NLS-1$
			"UTF-16", //$NON-NLS-1$
			"UTF-16BE", //$NON-NLS-1$
			"UTF-16LE", //$NON-NLS-1$
			"UTF-8", //$NON-NLS-1$
			"EUC_JP" //$NON-NLS-1$
	};

	private Combo comb;

	public void init(IWorkbench workbench) {
	}

	public CSVPreferencePage() {
		super();
		// setDescription("CSVo͂̐ݒ");
		// PreferenceStoreݒ肵Ă
		super.setPreferenceStore(DbPlugin.getDefault().getPreferenceStore());

	}

	public void createControl(Composite parent) {
		super.createControl(parent);
	}

	protected Control createContents(Composite parent) {
		// noDefaultAndApplyButton();

		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(1, false));
		base.setLayoutData(new GridData(GridData.FILL_BOTH));

		Group group = new Group(base, SWT.NONE);
		group.setLayout(new FillLayout(SWT.HORIZONTAL));
		group.setText(Messages.getString("CSVPreferencePage.12")); //$NON-NLS-1$

		Composite composite = new Composite(group, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));

		Label label = new Label(composite, SWT.NONE);
		label.setText(Messages.getString("CSVPreferencePage.13")); //$NON-NLS-1$

		comb = new Combo(composite, SWT.NONE);

		String defaultString = getPreferenceStore().getString(P_ENCODING);

		for (int i = 0; i < encordes.length; i++) {
			comb.add(encordes[i]);
			if (encordes[i].equals(defaultString)) {
				comb.select(i);
			}
		}

		if (comb.getSelectionIndex() == -1) {
			comb.add(defaultString, 0);
			comb.select(0);
		}

		return parent;
	}

	protected void performDefaults() {
		String defaultString = getPreferenceStore().getDefaultString(P_ENCODING);
		for (int i = 0; i < encordes.length; i++) {
			if (encordes[i].equals(defaultString)) {
				comb.select(i);
			}
		}
		super.performDefaults();
	}

	public boolean performOk() {
		getPreferenceStore().setValue(P_ENCODING, comb.getText());
		return super.performOk();
	}

}
