/*
 * 쐬: 2005/04/07
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.contentassist;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.sql.SqlEditor;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.SQLExecuteView;
import zigen.plugin.db.ui.views.internal.SQLWhitespaceDetector;

/**
 * ContentAssistUtilNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/10 ZIGEN create.
 * 
 */
public class ContentAssistUtil {

	/**
	 * sIhŏIĂ邩
	 * 
	 * @param document
	 * @param documentOffset
	 * @return
	 */
	public static boolean isAfterPeriod(IDocument document, int documentOffset) {
		try {
			char c = document.getChar(documentOffset - 1);
			if (c == '.') {
				return true;
			} else {
				return false;
			}
		} catch (BadLocationException e) {
			return false;
		}
	}

	// ݂̃ItZbg璼Ő󔒂܂ł̕Ԃ\bh
	public static String getPreviousWord(IDocument document, int documentOffset) {

		if (isAfterPeriod(document, documentOffset)) {
			// sIhŏIĂꍇ́AoffsetPOɂĂ
			--documentOffset;
		}

		// modify 2005-05-06 zigen
		SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();

		// Ő󔒂܂ł̕ǉ镶obt@
		StringBuffer buf = new StringBuffer();
		while (true) {
			try {
				// O̕擾
				char c = document.getChar(--documentOffset);
				// 󔒂sIhɓB
				// if (Character.isWhitespace(c) || c == '.') return
				// buf.reverse().toString();
				if (whiteSpace.isWhitespace(c) || c == '.')
					return buf.reverse().toString();
				// ǉ
				buf.append(c);

			} catch (BadLocationException e) {
				// hLg̐擪܂œBꍇ
				return buf.reverse().toString();
			}
		}
	}

	// ݂̃ItZbg璼Ő󔒂܂ł̕Ԃ\bh
	public static String getPreviousWordGroup(IDocument document, int documentOffset) {
		if (isAfterPeriod(document, documentOffset)) {
			// sIhŏIĂꍇ́AoffsetPOɂĂ
			--documentOffset;
		}

		// modify 2005-05-06 zigen
		SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();

		// Ő󔒂܂ł̕ǉ镶obt@
		StringBuffer buf = new StringBuffer();
		while (true) {
			try {
				// O̕擾
				char c = document.getChar(--documentOffset);
				// 󔒂ɓB
				// if (Character.isWhitespace(c)) return
				// buf.reverse().toString();
				if (whiteSpace.isWhitespace(c))
					return buf.reverse().toString();

				// ǉ
				buf.append(c);

			} catch (BadLocationException e) {
				// hLg̐擪܂œBꍇ
				return buf.reverse().toString();
			}
		}
	}

	/**
	 * ؂o
	 * 
	 * @param modifier
	 * @param length
	 * @return
	 */
	public static String subString(String modifier, int length) {
		if (modifier == null)
			return null;
		if (modifier.length() <= length) {
			return modifier;
		} else {
			return modifier.substring(0, length);
		}
	}

	public static IDBConfig getIDBConfig() {
		try {
			IWorkbenchPage page = DbPlugin.getDefault().getPage();
			IWorkbenchPart part = page.getActivePart();

			if (part instanceof SqlEditor) {
				SqlEditor editorPart = (SqlEditor) part;
				IEditorInput input = editorPart.getEditorInput();
				Object obj = input.getAdapter(IResource.class);
				if (obj instanceof IResource) {
					IResource rs = (IResource) obj;
					IDBConfig config = ResourceUtil.getDBConfig(rs);
					if (config == null) {
						DbPlugin.getDefault().showWarningMessage(Messages.getString("ContentAssistUtil.0")); //$NON-NLS-1$
					} else {
						return config;
					}
				}
			} else if (part instanceof SQLExecuteView) {
				SQLExecuteView viewPart = (SQLExecuteView) part;
				return viewPart.getConfig();

			} else if (part instanceof TableViewEditorFor31) {
				TableViewEditorFor31 editor = (TableViewEditorFor31) part;
				return editor.getTableNode().getDbConfig();

			} else {
				throw new IllegalStateException("\肵ĂȂł"); //$NON-NLS-1$
			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}
		return null;
	}

	/**
	 * ContentAssistTable쐬(R[h⊮pj
	 * 
	 * @param tableName
	 * @return
	 */
	public static ContentAssistTable createContentAssistTable(String tableName) {
        Display display = Display.getDefault();
        IDBConfig config = getIDBConfig();
		ContentAssistTable table = new ContentAssistTable(config, tableName);

		// J͔񓯊ɂȂ(ύXȂ)
		display.syncExec((Runnable) new ColumnSearchAction(table));

		// R[hAVXgp̃J
		//new ColumnSearchAction(table).run();

        if(table.getColumns() == null || table.getColumns().length == 0){
            // e[u啶ɕϊčČ
            table = new ContentAssistTable(config, tableName.toUpperCase());
            display.syncExec((Runnable) new ColumnSearchAction(table));
            
            if(table.getColumns() == null || table.getColumns().length == 0){
                // e[uɕϊčی
                table = new ContentAssistTable(config, tableName.toLowerCase());
                display.syncExec((Runnable) new ColumnSearchAction(table));
            }
            
        }
        
        // JtTableԂ
        return table;
	}

}
