/*
 * 쐬: 2005/03/26
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors;

import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.Condition;
import zigen.plugin.db.core.ConditionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.DeleteRecordAction;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.InsertRecordAction;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.actions.PasteRecordDataAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.event.TableDefaultSortListener;
import zigen.plugin.db.ui.editors.event.TableKeyAdapter;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.event.TableSortListener;
import zigen.plugin.db.ui.editors.internal.CellEditorType;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;
import zigen.plugin.db.ui.editors.internal.FileCellEditor;
import zigen.plugin.db.ui.editors.internal.TableDefineEditor;
import zigen.plugin.db.ui.editors.internal.thread.AbstractSQLThread;
import zigen.plugin.db.ui.editors.internal.thread.ModifyTableThread;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.ChangeColorJob;
import zigen.plugin.db.ui.jobs.RecordCountForTableJob;
import zigen.plugin.db.ui.jobs.RecordSearchJob;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.IStatusChangeListener;
import zigen.plugin.db.ui.views.StatusLineContributionItem;
import zigen.plugin.db.ui.views.TreeView;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;

/**
 * TableEditorNX.
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 */
public class TableViewEditorFor31 extends MultiPageEditorPart implements ITableViewEditor, IPropertyChangeListener, ISelectionListener, IStatusChangeListener {

    private boolean isEditing = false;

    private ConditionManager condiitonMgr = DbPlugin.getDefault().getConditionManager();

    private IDBConfig config;

    private SourceViewer logViewer;

    private TableViewer viewer;

    private SourceViewer ddlViewer; // DDL View

    protected SQLCodeConfiguration sqlConfiguration;

    protected ColorManager colorManager = new ColorManager();

    private Table table;

    protected ITable tableNode;

    private CellEditor[] cellEditors;

    private Label infoLabel;

    private TableElement[] elements;

    private int maxSize = 10;

    private List conditionHistory = new ArrayList();

    protected Combo conditionComb;

    private static final int CONDITION_SHOW_COLS = 20; // xɕ\ł鍀ڐ20Ƃ

    private TableKeyEventHandler handler;

    private Button searchBtn;

    protected InsertRecordAction insertRecordAction;

    protected SelectAllRecordAction selectAllRecordAction;

    protected DeleteRecordAction deleteAction;

    protected CopyRecordDataAction copyAction;

    protected PasteRecordDataAction pasteAction;

    protected ChangeColorJob changeColorJob;

    private TableSortListener sortListener;

    ColumnFilterInfo[] filterInfos;

    StatusLineContributionItem responseTimeItem;

    String responseTime;

    protected ISelection selection;

    protected MatchingCharacterPainter painter;

    protected LineNumberRulerColumn rulerCol;

    public TableViewEditorFor31() {
        super();
    }

    private void makeActions() {
        insertRecordAction = new InsertRecordAction();
        selectAllRecordAction = new SelectAllRecordAction();
        deleteAction = new DeleteRecordAction();
        copyAction = new CopyRecordDataAction();
        pasteAction = new PasteRecordDataAction();
        insertRecordAction.setActiveEditor(this);
        selectAllRecordAction.setActiveEditor(this);
        deleteAction.setActiveEditor(this);
        copyAction.setActiveEditor(this);
        pasteAction.setActiveEditor(this);

    }

    private void saveConditionHistory() {
        String schemaName = tableNode.getSchemaName();
        String tableName = tableNode.getName();
        Condition condition = new Condition();
        String url = config.getUrl();
        condition.setConnectionUrl(url);
        condition.setSchema(schemaName);
        condition.setTable(tableName);
        condition.setConditions(conditionHistory);
        condiitonMgr.setCondition(condition);
    }

    private void loadConditionHistory() {
        String url = config.getUrl();
        String schemaName = tableNode.getSchemaName();
        String tableName = tableNode.getName();
        Condition condition = condiitonMgr.getCondition(url, schemaName, tableName);
        if (condition != null) {
            conditionHistory = condition.getConditions();
        }
    }

    protected void createPages() {
        makeActions();
        createLogPage();
        createDefinPage();
        createDDLPage();
        // createMainPage();
        loadConditionHistory();
        DbPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this);
        StatusChangeListener.addStatusChangeListener(this);

    }

    private void createLogPage() {
        Composite composite = new Composite(getContainer(), SWT.NONE);
        composite.setLayout(new FillLayout());
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, new LineNumberRulerColumn());
        logViewer = new SourceViewer(composite, ruler, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
        initializeViewerFont(logViewer);
        sqlConfiguration = new SQLCodeConfiguration(colorManager);
        logViewer.configure(sqlConfiguration);
        logViewer.setDocument(new SQLDocument());
        logViewer.setEditable(false);
        int index = addPage(composite);
        setPageText(index, Messages.getString("TableViewEditorFor31.0")); //$NON-NLS-1$

    }

    private void createDDLPage() {
        Composite composite = new Composite(getContainer(), SWT.NONE);
        composite.setLayout(new FillLayout());
        CompositeRuler ruler = new CompositeRuler();
        rulerCol = new LineNumberRulerColumn();
        ruler.addDecorator(0, rulerCol);
        ddlViewer = new SourceViewer(composite, ruler, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
        initializeViewerFont(ddlViewer);
        sqlConfiguration = new SQLCodeConfiguration(colorManager);
        ddlViewer.configure(sqlConfiguration);
        ddlViewer.setDocument(new SQLDocument());
        ITextViewerExtension2 extension = (ITextViewerExtension2) ddlViewer;
        painter = new MatchingCharacterPainter(ddlViewer, new SQLCharacterPairMatcher());
        painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
        extension.addPainter(painter);
        StyledTextUtil.changeColor(colorManager, ddlViewer.getTextWidget());
        ddlViewer.setEditable(false);
        int index = addPage(composite);
        setPageText(index, Messages.getString("TableViewEditorFor31.1")); //$NON-NLS-1$
    }

    private void createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL)); // ㉺L
        composite.setLayout(new FillLayout(SWT.HORIZONTAL));
        infoLabel = new Label(composite, SWT.NONE);
        infoLabel.setText(""); //$NON-NLS-1$
        infoLabel.setForeground(new Color(null, 255, 0, 0));
    }

    private void createMainPage() {
        Composite main = new Composite(getContainer(), SWT.NONE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        main.setLayout(gridLayout);

        // c[o[̈p
        createToolBar(main);

        table = new Table(main, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
        GridData gridData2 = new GridData(GridData.FILL_BOTH);
        table.setLayoutData(gridData2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(DbPlugin.getDefaultFont());

        viewer = new TableViewer(table);
        // handler = new TableKeyEventHandler(viewer);
        handler = new TableKeyEventHandler(this);

        setHeaderColumn(table);// e[uwb_̐ݒ
        setCellModify(viewer, filterInfos);// ZfBt@C̐ݒ

        viewer.setContentProvider(new TableViewContentProvider());
        viewer.setLabelProvider(new TableViewLabelProvider());

        // _uNbÑCxgǉ
        table.addMouseListener(new MouseAdapter() {
            // public void mouseDoubleClick(MouseEvent e) {
            // doubleClickHandler(e);
            // }
        });

        table.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.F2) {
                    // R[hIA擪̃JҏWԂɂ
                    int row = handler.getSelectedRow();
                    handler.editTableElement(row, 1);

                }
            }
        });
        table.addFocusListener(new FocusAdapter() {
            public void focusGained(FocusEvent e) {
                if (table.getSelectionIndex() == -1) {
                    table.select(0); // Ȉꍇ́AI1R[hڂI
                    table.notifyListeners(SWT.Selection, null); // IԂʒm

                }
                // e[upActionBarɂ
                IActionBars bars = getEditorSite().getActionBars();
                setGlobalActionForEditor(bars);
                bars.updateActionBars();

            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener() {
            public void selectionChanged(SelectionChangedEvent e) {
                selectionChangeHandler(e);
            }

        });

        viewer.setInput(elements);

        columnsPack(table);

        createMessageArea(main);
        hookContextMenu();
        contributeToStatusLine();

        int maxPage = 3; // OA`ADDL
        if (this.getPageCount() > maxPage) {
            this.removePage(getPageCount() - 1);
        }

        int index = addPage(main);
        setActivePage(getPageCount() - 1);
        getSite().setSelectionProvider(viewer);
        getEditorSite().getPage().addSelectionListener(this);
        setKeyBinding();

        // changeColorAction = new ChangeColorAction(table, tableNode);
        // Display display = Display.getCurrent();
        // display.asyncExec(changeColorAction);

        changeColorJob = new ChangeColorJob(table, tableNode);
        changeColorJob.setPriority(ChangeColorJob.LONG);
        changeColorJob.setUser(false);
        changeColorJob.schedule();

    }

    // for Eclipse3.2 Keybinding(VKR[h쐬j
    protected void setKeyBinding() {
        ;
    }

    private boolean hasContributionItem(IStatusLineManager manager, String id) {
        IContributionItem[] items = manager.getItems();
        for (int i = 0; i < items.length; i++) {
            IContributionItem item = items[i];
            if (item.getId().equals(id)) {
                responseTimeItem = (StatusLineContributionItem) item;
                return true;
            }
        }
        return false;
    }

    public void contributeToStatusLine() {
        IStatusLineManager manager = getIStatusLineManager();
        if (!hasContributionItem(manager, "RecordCount")) { //$NON-NLS-1$
            responseTimeItem = new StatusLineContributionItem("RecordCount"); //$NON-NLS-1$
            manager.add(responseTimeItem);
        }

    }

    public void setTotalCount(String dispCount, String totalCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("["); //$NON-NLS-1$
        sb.append(config.getDbName());
        sb.append("] "); //$NON-NLS-1$
        sb.append(dispCount);
        sb.append(""); //$NON-NLS-1$
        if (!"".equals(totalCount)) { //$NON-NLS-1$
            if ("-1".equals(totalCount)) { //$NON-NLS-1$
                ; // Ή̏ꍇ͉Ȃ
            } else {
                sb.append(" / "); //$NON-NLS-1$
                sb.append(""); //$NON-NLS-1$
                sb.append(totalCount);
                sb.append(Messages.getString("TableViewEditorFor31.12")); //$NON-NLS-1$
            }
        } else {
            sb.append(Messages.getString("TableViewEditorFor31.13")); //$NON-NLS-1$
        }
        sb.append(Messages.getString("TableViewEditorFor31.14")); //$NON-NLS-1$
        sb.append(responseTime);
        sb.append("]"); //$NON-NLS-1$

        // setPageText(getActivePage(), sb.toString());
        setPageText(getPageCount() - 1, sb.toString());
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;

        if (responseTimeItem != null && responseTime != null && !"".equals(responseTime)) { //$NON-NLS-1$
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("TableViewEditorFor31.17")); //$NON-NLS-1$
            sb.append(responseTime);
            responseTimeItem.setText(sb.toString());

        }
    }

    public void refleshAction() {
        deleteAction.refresh();
        copyAction.refresh();
        pasteAction.refresh();
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        refleshAction();
    }

    // for Eclipse3.1
    protected void conditionEventHandler(KeyEvent e) {
        if (e.character == SWT.CR) {
            e.doit = true;
            updateTableViewer(conditionComb.getText());
        }
    }

    private void createToolBar(Composite parent) {
        GridData gridData;
        final Composite tool = new Composite(parent, SWT.NONE);
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        tool.setLayoutData(gridData);

        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;

        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        tool.setLayout(gridLayout);

        Label label1 = new Label(tool, SWT.NULL);
        gridData = new GridData(GridData.FILL);
        label1.setLayoutData(gridData);
        label1.setText(Messages.getString("TableViewEditorFor31.18")); //$NON-NLS-1$

        conditionComb = new Combo(tool, SWT.NONE);
        conditionComb.setVisibleItemCount(CONDITION_SHOW_COLS);
        conditionComb.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        conditionComb.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e) {
                conditionEventHandler(e);
            }
        });

        // ------------------------------------------
        // R[hAVXg only Eclipse 3.2
        // ------------------------------------------
        AddContentAssist();

        conditionComb.addTraverseListener(new TraverseListener() {
            public void keyTraversed(TraverseEvent e) {
                if (e.character == SWT.TAB) {
                    if (table.getItemCount() == 0) {
                        // ʂ0̏ꍇ
                        handler.createNewRecord();
                    }

                }
            }
        });

        conditionComb.setFont(DbPlugin.getDefaultFont());
        searchBtn = new Button(tool, SWT.NONE);
        searchBtn.setText(Messages.getString("TableViewEditorFor31.19")); //$NON-NLS-1$
        searchBtn.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                updateTableViewer(conditionComb.getText());
            }
        });

        conditionComb.addFocusListener(new FocusAdapter() {
            public void focusGained(FocusEvent e) {
                IActionBars bars = getEditorSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }

        });

        Button filterBtn = new Button(tool, SWT.NONE);
        filterBtn.setText(Messages.getString("TableViewEditorFor31.20")); //$NON-NLS-1$
        filterBtn.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                filterBtnSelectHandler(event);
            }
        });

        if (conditionHistory != null) {
            for (int i = 0; i < conditionHistory.size(); i++) {
                conditionComb.add((String) conditionHistory.get(i));
            }
        }

    }

    private void filterBtnSelectHandler(SelectionEvent event) {
        Shell shell = this.getSite().getShell();
        ColumnFilterDialog dialog = new ColumnFilterDialog(shell, this);
        dialog.open();
    }

    public void removeOverHistory() {
        while (conditionHistory.size() > maxSize) { // 󔒗pl
            int i = conditionHistory.size() - 1;
            conditionHistory.remove(i);
            conditionComb.remove(i);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {

                switch (getActivePage()) {
                    case SHEET_INFO:
                        if (tableDefineEditor.focusDefine()) {
                            ISelection selection = tableDefineEditor.getDefineViewer().getSelection();
                            getContributor().fillContextMenuForDefine(manager, selection);
                        } else {
                            ISelection selection = tableDefineEditor.getConstraintViewer().getSelection();
                            getContributor().fillContextMenuForConstraints(manager, selection);
                        }

                        break;
                    case SHEET_DATA:
                        getContributor().fillContextMenu(manager);
                        break;
                    default:
                        break;
                }

            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(menuMgr, viewer);

        Menu menu2 = menuMgr.createContextMenu(tableDefineEditor.getDefineViewer().getControl());
        tableDefineEditor.getDefineViewer().getControl().setMenu(menu2);
        getSite().registerContextMenu(menuMgr, tableDefineEditor.getDefineViewer());

        Menu menu3 = menuMgr.createContextMenu(tableDefineEditor.getConstraintViewer().getControl());
        tableDefineEditor.getConstraintViewer().getControl().setMenu(menu3);
        getSite().registerContextMenu(menuMgr, tableDefineEditor.getConstraintViewer());

    }

    private TableViewerContributor getContributor() {
        IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
        if (contributor instanceof TableViewerContributor) {
            return (TableViewerContributor) contributor;
        } else {
            return null;
        }
    }

    private void setHeaderColumn(Table table) {
        if (elements != null) {
            TableColumn row = new TableColumn(table, SWT.LEFT);
            sortListener = new TableSortListener(this, 0);
            row.addSelectionListener(sortListener);
            row.pack();
            TableElement element = elements[0]; // wb_[pJ
            zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
            for (int i = 0; i < columns.length; i++) {
                zigen.plugin.db.core.TableColumn tColumn = columns[i];
                TableColumn col = new TableColumn(table, SWT.LEFT);
                col.setText(tColumn.getColumnName());
                col.addSelectionListener(new TableSortListener(this, i + 1));
                col.pack();
            }
        }
    }

    private void setCellModify(TableViewer viewer, ColumnFilterInfo[] filterInfo) {
        if (elements == null)
            return;
        final IActionBars bars = getEditorSite().getActionBars();
        TableElement element = elements[0];// wb_[pTableElement̎擾
        int size = element.getColumns().length + 1; // ROWpɒǉ
        String[] properties = new String[size];
        zigen.plugin.db.core.TableColumn[] cols = element.getColumns();
        cellEditors = new CellEditor[size];
        TableKeyAdapter keyAdapter = new TableKeyAdapter(handler);
        for (int i = 0; i < cellEditors.length; i++) {
            properties[i] = String.valueOf(i); // property ƂIndexԍn
            if (i > 0) { // 1Jڈȍ~XV\Ƃ
                CellEditor cellEditor = null;
                if (CellEditorType.isFileSaveType(cols[i - 1])) {
                    cellEditor = new FileCellEditor(table);
                } else {
                    cellEditor = new TextCellEditor(table);
                }
                cellEditor.getControl().addKeyListener(keyAdapter);
                cellEditor.getControl().addTraverseListener(keyAdapter);
                cellEditor.getControl().addFocusListener(new FocusAdapter() {
                    public void focusGained(FocusEvent e) {
                        setInfomationText(EDIT_MODE_ON);
                        isEditing = true; // ҏWtOON
                        bars.clearGlobalActionHandlers();
                        bars.updateActionBars();
                    }

                    public void focusLost(FocusEvent e) {
                        setInfomationText(EDIT_MODE_OFF);
                        isEditing = false; // ҏWtOOFF
                    }
                });

                cellEditor.setValidator(new CellEditorValidator(config, viewer, i));
                cellEditors[i] = cellEditor;

            }
        }
        viewer.setColumnProperties(properties);
        // viewer.setCellModifier(new CellModifier(viewer, tableNode,
        // filterInfo));
        viewer.setCellModifier(new CellModifier(this, filterInfo));

        viewer.setCellEditors(cellEditors);
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        for (int i = 0; i < cols.length; i++) {
            cols[i].pack();
        }
        table.setVisible(true);
    }

    public void dispose() {
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this);
        getEditorSite().getPage().removeSelectionListener(this);
        StatusChangeListener.removeStatusChangeListener(this);
        insertRecordAction.setActiveEditor(null);
        selectAllRecordAction.setActiveEditor(null);
        deleteAction.setActiveEditor(null);
        copyAction.setActiveEditor(null);
        pasteAction.setActiveEditor(null);
        if (handler != null) {
            handler.dispose();
            handler = null;
        }
        saveConditionHistory();
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        try {
            if (editorInput instanceof TableViewEditorInput) {
                TableViewEditorInput input = (TableViewEditorInput) editorInput;
                this.config = input.getConfig();
                this.tableNode = input.getTable();
                String partName = this.tableNode.getSqlTableName();
                setPartName(partName);
                input.setToolTipText("[" + input.getConfig().getDbName() + "] " + partName); //$NON-NLS-1$ //$NON-NLS-2$

                setStatusMessage(input.getToolTipText());
            }

        } catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void updateTableViewer(String condition) {
        RecordSearchJob job = new RecordSearchJob(this, condition);
        job.setPriority(RecordSearchJob.SHORT);
        job.setUser(true);
        job.schedule();
    }

    // JOBNXĂ΂郁\bh
    public void updateTableViewer(String condition, TableElement[] elements, String responseTime) {

        try {
            viewer.setInput(elements);
            TableColumn col = viewer.getTable().getColumn(0);
            col.pack();// 擪̕pbN

            TableDefaultSortListener defaultSortListener = new TableDefaultSortListener(this, 0);
            // sortListenerU폜
            col.removeSelectionListener(sortListener);
            // \pSortListenero^
            col.addSelectionListener(defaultSortListener);
            viewer.getTable().getColumn(0).notifyListeners(SWT.Selection, null);
            // ̃Xi[ɖ߂
            col.removeSelectionListener(defaultSortListener);
            sortListener = new TableSortListener(this, 0);
            col.addSelectionListener(sortListener);
            // vx폜AŏʂɈړ
            if (conditionHistory.contains(condition)) {
                conditionHistory.remove(condition);
                conditionComb.remove(condition);
            }
            conditionHistory.add(0, condition); // 擪ɒǉ
            conditionComb.add(condition, 0); // 擪ɒǉ
            conditionComb.select(0);// 擪I
            // ől𒴂폜
            removeOverHistory();

            // 
            setResponseTime(responseTime);

            // R[h̕\
            int dispCnt = elements.length - 1;
            NumberFormat format = NumberFormat.getInstance();
            setTotalCount(format.format(dispCnt), ""); //$NON-NLS-1$
            RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(config), tableNode, condition, dispCnt);
            job2.setUser(false);
            job2.schedule();

        } catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    public void update(IDBConfig config, ITable iTable, boolean isSearch) {
        // EditorInputɂTableĐݒ肷
        TableViewEditorInput input = new TableViewEditorInput(config, iTable);
        this.setInput(input);
        this.config = config; // DBConfigVݒ肷邱

        // JĂꍇ́AČȂ悤ɂ(̓IvVKvHj
        if (viewer == null || isSearch) {
            String maxRecordMessage = ""; //$NON-NLS-1$
            TimeWatcher time = new TimeWatcher();
            time.start();
            try {
                elements = TableManager.invoke(config, iTable);
            } catch (MaxRecordException e) {
                elements = e.getTableElements();
                // DbPlugin.getDefault().showWaringMessage(e.getMessage());
                maxRecordMessage = e.getMessage();
            } catch (SQLException e) {
                DbPlugin.getDefault().showWarningMessage(e.getMessage());
            } catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            } finally {
                time.stop();
            }

            if (tableDefineEditor != null) {
                tableDefineEditor.updateWidget();
                setDirty(false);// ύXʒm
            }
            createMainPage();

            // bZ[Wݒ
            setInfomationText(maxRecordMessage);

            setResponseTime(time.getTotalTime());// 
            // R[h̕\
            if (elements != null) {
                int dispCnt = elements.length - 1;
                NumberFormat format = NumberFormat.getInstance();
                setTotalCount(format.format(dispCnt), ""); //$NON-NLS-1$
                RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(config), iTable, null, dispCnt);
                job2.setUser(false);
                job2.schedule();
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public void editTableElement(Object element, int column) {
        viewer.cancelEditing();
        viewer.editElement(element, column);
    }

    public TableViewer getViewer() {
        return viewer;
    }

    public void setInfomationText(String text) {
        infoLabel.setText(text);
    }

    public TableElement getHeaderTableElement() {
        Object obj = viewer.getInput();
        if (obj instanceof TableElement[]) {
            TableElement[] elements = (TableElement[]) obj;
            if (elements.length > 0) {
                return elements[0];
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    public ITable getTableNode() {
        return tableNode;
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    public void setFocus() {
        setResponseTime(responseTime);
        // ǉ@\(DBc[ƃN)
        StatusChangeListener.fireStatusChangeListener(selection, StatusChangeListener.EVT_LinkTable);

        IActionBars bars = getEditorSite().getActionBars();
        bars.clearGlobalActionHandlers();

        switch (getActivePage()) {
            case SHEET_LOG:
                setGlobalActionForLog(bars);
                break;

            case SHEET_INFO:
                if (tableDefineEditor != null) {
                    tableDefineEditor.updateWidget();
                }
                setDirty(false);// ύXʒm
                tableDefineEditor.setFocus();
                break;

            case SHEET_DDL:// DDLV[g
                setDDLString();
                setGlobalActionForDDL(bars);
                break;

            case SHEET_DATA:// EditorV[g
                Column[] columns = tableNode.getColumns();
                ColumnFilterInfo[] newfilterInfos = new ColumnFilterInfo[columns.length];

                for (int i = 0; i < columns.length; i++) {
                    newfilterInfos[i] = new ColumnFilterInfo(columns[i]);

                    if (filterInfos != null) {
                        // ݒς݂Filterp
                        for (int j = 0; j < filterInfos.length; j++) {
                            if (columns[i].getColumn().getColumnName().equals(filterInfos[j].getColumnName())) {
                                newfilterInfos[i].setChecked(filterInfos[j].isChecked());
                                break;
                            }
                        }
                    }
                }

                filterInfos = newfilterInfos;
                setCellModify(viewer, filterInfos);// ZfBt@C̐ݒ
                setGlobalActionForEditor(bars);
                conditionComb.setFocus();
                break;

            default:
                break;
        }

        bars.updateActionBars();

        setStatusMessage(getEditorInput().getToolTipText());
    }

    void setDDLString() {
        try {
            ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, tableNode);
            ddlViewer.getDocument().set(factory.createDDL());
        } catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    void setGlobalActionForLog(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), new GlobalAction(logViewer, ITextOperationTarget.SELECT_ALL));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), new GlobalAction(logViewer, ITextOperationTarget.COPY));
        insertRecordAction.setEnabled(false); // V[gJbgΏۂAction𖳌
    }

    void setGlobalActionForDDL(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), new GlobalAction(ddlViewer, ITextOperationTarget.SELECT_ALL));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), new GlobalAction(ddlViewer, ITextOperationTarget.COPY));
        insertRecordAction.setEnabled(false); // V[gJbgΏۂAction𖳌
    }

    void setGlobalActionForEditor(IActionBars bars) {
        bars.setGlobalActionHandler("zigen.plugin.db.actions.InsertRecordAction", insertRecordAction); //$NON-NLS-1$
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAllRecordAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), pasteAction);
        insertRecordAction.setEnabled(true); // V[gJbgΏۂActionL

    }

    public SourceViewer getLogViewer() {
        return logViewer;
    }

    protected void AddContentAssist() {
        ; // Eclipse 3.1ł͎s
    }

    public IDBConfig getDBConfig() {
        return config;
    }

    private TableDefineEditor tableDefineEditor;

    private void createDefinPage() {
        Composite composite = new Composite(getContainer(), SWT.NONE);
        composite.setLayout(new FillLayout());
        tableDefineEditor = new TableDefineEditor(composite, tableNode);
        tableDefineEditor.setEditor(this);
        tableDefineEditor.createWidget();
        int index = addPage(composite);
        setPageText(index, Messages.getString("TableViewEditorFor31.28")); //$NON-NLS-1$

    }

    public void doSave(IProgressMonitor monitor) {
        try {
            String newTableName = tableDefineEditor.getTableName();
            String newRemarks = tableDefineEditor.getTableComment();
            AbstractSQLThread invoker = new ModifyTableThread(tableNode, newTableName, newRemarks);
            invoker.run();

            TableViewEditorInput input = (TableViewEditorInput) getEditorInput();
            String partName = this.tableNode.getSqlTableName();
            setPartName(partName);
            input.setToolTipText("[" + input.getConfig().getDbName() + "] " + partName); //$NON-NLS-1$ //$NON-NLS-2$

            setStatusMessage(input.getToolTipText());
            // ύXʒm(OFF)
            setDirty(false);

        } catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    boolean dirty;

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return dirty;
    }

    public void setDirty(boolean value) {
        dirty = value;
        firePropertyChange(PROP_DIRTY);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void changeColumnColor(Column column) {
        changeColorJob.setSelectedColumn(column);
        changeColorJob.schedule();

    }

    public void changeColumnColor() {
        changeColorJob.setTable(table);
        changeColorJob.schedule();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection _selection) {
        if (_selection != null && _selection instanceof StructuredSelection) {

            if (part instanceof TreeView) {
                TreeView tree = (TreeView) part;
                if (tree.isLinkingEnabled() && _selection.equals(this.selection)) {
                    // // GfB^[NȂ(ݒt@C邱)
                    try {
                        getSite().getPage().openEditor(getEditorInput(), DbPluginConstant.EDITOR_ID_TableEditor, false);
                    } catch (PartInitException e) {
                        DbPlugin.getDefault().showErrorDialog(e);
                    }
                }

                Object obj = ((StructuredSelection) _selection).getFirstElement();
                if (obj != null) {
                    if (obj instanceof Column) {
                        // e[uҏWGfB^[̃JI
                        Column column = (Column) obj;
                        if (column.getTable().equals(tableNode)) {
                            changeColumnColor((Column) obj);
                        }
                    }
                    if (obj instanceof ITable) {
                        // e[uҏWGfB^[̃JI
                        ITable t = (ITable) obj;
                        if (t.equals(tableNode)) {
                            changeColumnColor(null);
                        }
                    }

                }
            }

        }

    }

    public void statusChanged(Object obj, int status) {
        if (status == StatusChangeListener.EVT_RefreshTable) {
            if (obj instanceof ITable) {
                ITable wk = (ITable) obj;
                if (wk.equals(tableNode)) {
                    if (tableDefineEditor != null) {
                        tableDefineEditor.updateWidget();
                    }
                    setDirty(false);// ύXʒm
                    int current = getActivePage();
                    IDBConfig wkConfig = wk.getDbConfig();
                    boolean isSearch = true; // Č
                    update(wkConfig, wk, isSearch);

                    setActivePage(current);
                    
                    // EditorPart̖Oϖ
                    String partName = this.tableNode.getSqlTableName();
                    setPartName(partName);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (sqlConfiguration != null && ddlViewer != null) {
            StyledTextUtil.changeColor(colorManager, ddlViewer.getTextWidget());
            LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
            sqlConfiguration.updatePreferences(ddlViewer.getDocument());
            painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
            ddlViewer.invalidateTextPresentation();// eLXgGfB^ĕ`
        }
    }

    public TableDefineEditor getTableDefineEditor() {
        return tableDefineEditor;
    }

    public String getCondition() {
        if (conditionComb != null) {
            return conditionComb.getText();
        } else {
            return null;
        }
    }

    public ColumnFilterInfo[] getFilterInfos() {
        return filterInfos;
    }

    // DB Tree ViewSelection
    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected IStatusLineManager getIStatusLineManager() {
        IEditorSite vieweSite = super.getEditorSite();
        IActionBars actionBars = vieweSite.getActionBars();
        return actionBars.getStatusLineManager();

    }

    public void setStatusMessage(String message) {
        getIStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        getIStatusLineManager().setErrorMessage(message);
    }
}
