/*
 * 쐬: 2005/03/26
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.IHandlerService;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.views.internal.SQLWhitespaceDetector;

/**
 * TableEditorNX.
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 */
public class TableViewEditorFor32 extends TableViewEditorFor31 implements ITableViewEditor {
	private int wordLen = 0;// R[hAVXgpP̒i[

	private boolean contentAssisting = false;

	private boolean proposalFiltering = false;

	static final String[] Keywords = {
			"AND",
			"ASC",
			"BETWEEN",
			"BY",
			"DESC",
			"EXISTS",
			"IN",
			"IS NULL",
			"IS NOT NULL",
			"LIKE",
			"NOT",
			"NOT EXISTS",
			"NULL",
			"OR",
			"ORDER BY"
	};

	private class ColumnContentProposal implements IContentProposalProvider {

		IContentProposal[] contentProposals;

		Column[] columns;

		public ColumnContentProposal(Column[] columns) {
			this.columns = columns;
			//this.contentProposals = new IContentProposal[columns.length];
			this.contentProposals = new IContentProposal[columns.length+Keywords.length];
			
		}

		private void setColumnProposal(List proposalList, String word){
			for (int i = 0; i < columns.length; i++) {
				final Column col = columns[i];
				final String colName = col.getName();
				final String value = ContentAssistUtil.subString(colName, wordLen);
				if (word != null && !"".equals(word)) { //$NON-NLS-1$
					proposalFiltering = true; // ̍i荞݃[hON
					if (value.compareToIgnoreCase(word) == 0) {
						// ̍쐬ƒǉ
						IContentProposal p = new IContentProposal() {
							public String getContent() {
								return colName;
							}

							public String getDescription() {
								return null;
							}

							public String getLabel() {
								return col.getColumnLabel();
							}

							public int getCursorPosition() {
								// i荞񂾕
								// return col.getName().length() - wordLen;
								// i荞񂾏ꍇ́A㏑邽߁AʏǂԂ
								return col.getName().length();

							}
						};
						proposalList.add(p);
					}
				} else {
					proposalFiltering = false; // ̍i荞݃[hOFF
					// ̍쐬ƒǉ
					IContentProposal p = new IContentProposal() {
						public String getContent() {
							return colName;
						}

						public String getDescription() {
							return null;
						}

						public String getLabel() {
							return col.getColumnLabel();
						}

						public int getCursorPosition() {
							return col.getName().length();
						}
					};
					proposalList.add(p);
				}

			}
		}
		
		private void setKeywordProposal(List proposalList, String word){
			for (int i = 0; i < Keywords.length; i++) {
				final String keyword = Keywords[i];
				final String value = ContentAssistUtil.subString(keyword, wordLen);
				if (word != null && !"".equals(word)) { //$NON-NLS-1$
					proposalFiltering = true; // ̍i荞݃[hON
					if (value.compareToIgnoreCase(word) == 0) {
						// ̍쐬ƒǉ
						IContentProposal p = new IContentProposal() {
							public String getContent() {
								return keyword;
							}

							public String getDescription() {
								return null;
							}

							public String getLabel() {
								return keyword;
							}

							public int getCursorPosition() {
								// i荞񂾕
								// return col.getName().length() - wordLen;
								// i荞񂾏ꍇ́A㏑邽߁AʏǂԂ
								return keyword.length();

							}
						};
						proposalList.add(p);
					}
				} else {
					proposalFiltering = false; // ̍i荞݃[hOFF
					// ̍쐬ƒǉ
					IContentProposal p = new IContentProposal() {
						public String getContent() {
							return keyword;
						}

						public String getDescription() {
							return null;
						}

						public String getLabel() {
							return keyword;
						}

						public int getCursorPosition() {
							return keyword.length();
						}
					};
					proposalList.add(p);
				}

			}
		}
		
		public IContentProposal[] getProposals(String contents, int position) {

			List proposalList = new ArrayList();
			String word = getPreviousWord(contents, position);
			wordLen = word.length();

			setColumnProposal(proposalList, word);
			setKeywordProposal(proposalList, word);
//			
//			for (int i = 0; i < columns.length; i++) {
//				final Column col = columns[i];
//				final String colName = col.getName();
//				final String value = ContentAssistUtil.subString(colName, wordLen);
//				if (word != null && !"".equals(word)) { //$NON-NLS-1$
//					proposalFiltering = true; // ̍i荞݃[hON
//					if (value.compareToIgnoreCase(word) == 0) {
//						// ̍쐬ƒǉ
//						IContentProposal p = new IContentProposal() {
//							public String getContent() {
//								return colName;
//							}
//
//							public String getDescription() {
//								return null;
//							}
//
//							public String getLabel() {
//								return col.getColumnLabel();
//							}
//
//							public int getCursorPosition() {
//								// i荞񂾕
//								// return col.getName().length() - wordLen;
//								// i荞񂾏ꍇ́A㏑邽߁AʏǂԂ
//								return col.getName().length();
//
//							}
//						};
//						proposalList.add(p);
//					}
//				} else {
//					proposalFiltering = false; // ̍i荞݃[hOFF
//					// ̍쐬ƒǉ
//					IContentProposal p = new IContentProposal() {
//						public String getContent() {
//							return colName;
//						}
//
//						public String getDescription() {
//							return null;
//						}
//
//						public String getLabel() {
//							return col.getColumnLabel();
//						}
//
//						public int getCursorPosition() {
//							return col.getName().length();
//						}
//					};
//					proposalList.add(p);
//				}
//
//			}

			// ₪Ȍꍇl
			if (proposalList.size() == 0) {
				contentAssisting = false;
			}
			return (IContentProposal[]) proposalList.toArray(new IContentProposal[0]);
		}

	}

	private class ColumnComboContentAdapter extends ComboContentAdapter {
		public void insertControlContents(Control control, String text, int cursorPosition) {
			super.insertControlContents(control, text, cursorPosition);
			contentAssisting = false;// RecAVXgI
		}

		public void setControlContents(Control control, String text, int cursorPosition) {
			super.setControlContents(control, text, cursorPosition);
		}

		public void setCursorPosition(Control control, int index) {
			// i荞݂Ă镶  i荞ݕ͒u
			Combo cmb = (Combo) control;
			String text = cmb.getText();
			cmb.setText(text.substring(0, index - wordLen) + text.substring(index));
			super.setCursorPosition(control, (index - wordLen));
		}

		public ColumnComboContentAdapter() {

		}
	}

	public TableViewEditorFor32() {
		super();
	}

	protected void conditionEventHandler(KeyEvent e) {
		if (e.character == SWT.CR && !contentAssisting) {
			e.doit = true;
			updateTableViewer(conditionComb.getText());

		} else if (e.stateMask == SWT.CTRL && e.character == ' ') {
			contentAssisting = true;
			e.doit = false;

		}
	}

	// ݂̃ItZbg璼Ő󔒂܂ł̕Ԃ\bh
	private String getPreviousWord(String contents, int position) {
		SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();
		StringBuffer buf = new StringBuffer();
		while (true) {
			try {
				char c = contents.charAt(--position);
				// 󔒂sIhɓB
				// if (Character.isWhitespace(c) || c == '.') return
				// buf.reverse().toString();
				if (whiteSpace.isWhitespace(c) || c == '.')
					return buf.reverse().toString();
				// ǉ
				buf.append(c);
			} catch (Exception e) {
				// hLg̐擪܂œBꍇ
				return buf.reverse().toString();
			}
		}
	}

	protected void AddContentAssist() {
		try {
			Column[] columns = tableNode.getColumns();
			IContentProposalProvider proposal = new ColumnContentProposal(columns);
			KeyStroke keyStroke = KeyStroke.getInstance("Ctrl+Space"); //$NON-NLS-1$
			new ContentProposalAdapter(conditionComb, new ColumnComboContentAdapter(), proposal, keyStroke, null);
		} catch (ParseException e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	protected void setKeyBinding() {
		try {
			IHandlerService service = (IHandlerService) getEditorSite().getService(IHandlerService.class);
			service.activateHandler("zigen.plugin.InsertRecordCommand", new ActionHandler(insertRecordAction)); //$NON-NLS-1$
		} catch (NoClassDefFoundError e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}
}
