package zigen.plugin.db.ui.editors.sql;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.PLSQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.PLSQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLPartitionScanner;

public class PlsqlEditor extends TextEditor implements IPlsqlEditor, IPropertyChangeListener, ISelectionListener {


    protected PLSQLSourceViewer sqlViewer;

    protected PLSQLCodeConfiguration sqlConfiguration;

    protected IFile file;

    protected ColorManager colorManager;

    protected LineNumberRulerColumn rulerCol;

    protected IPreferenceStore store;

    protected IDBConfig config;

    protected ProjectionSupport projectionSupport;
    

    IResource resource = null;

    public PlsqlEditor() {
        super();
        colorManager = new ColorManager();
        sqlConfiguration = new PLSQLCodeConfiguration(colorManager);
        setSourceViewerConfiguration(sqlConfiguration);
        this.store = DbPlugin.getDefault().getPreferenceStore();
        this.store.addPropertyChangeListener(this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        setSite(site);
        setInput(editorInput);
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fi = (FileEditorInput) editorInput;
            file = fi.getFile();
            config = ResourceUtil.getDBConfig(file);
            
        }
        resource = (IResource) getEditorInput().getAdapter(IResource.class);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        sqlViewer = (PLSQLSourceViewer) getSourceViewer();
        sqlViewer.setDbConfig(config); // DBConfigݒ肷

        IDocument doc = sqlViewer.getDocument();
        IDocumentPartitioner partitioner = new FastPartitioner(new SQLPartitionScanner(), new String[] {SQLPartitionScanner.SQL_STRING,
                SQLPartitionScanner.SQL_COMMENT});
        partitioner.connect(doc);
        doc.setDocumentPartitioner(partitioner);

        // Exception in thread "Thread-2" org.eclipse.swt.SWTError: Cannot
        // initialize Drop
        // 邽߁Aȉ̏̓RgƂ
        // DropTarget target = new DropTarget(sqlViewer.getTextWidget(),
        // DND.DROP_DEFAULT | DND.DROP_COPY | DND.DROP_MOVE | DND.DROP_LINK);
        // Transfer[] types = new Transfer[] {
        // TreeLeafListTransfer.getInstance(),
        // TextTransfer.getInstance(), FileTransfer.getInstance() };
        // target.setTransfer(types);
        // target.addDropListener(new DropTreeLeafAdapter(sqlViewer));

        ITextViewerExtension2 extension = (ITextViewerExtension2) sqlViewer;
        MatchingCharacterPainter painter = new MatchingCharacterPainter(sqlViewer, new SQLCharacterPairMatcher());
        painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
        extension.addPainter(painter);

        ProjectionViewer pviewer = (ProjectionViewer) getSourceViewer();
        projectionSupport = new ProjectionSupport(pviewer, getAnnotationAccess(), getSharedColors());
        projectionSupport.install();
        pviewer.doOperation(ProjectionViewer.TOGGLE);
        updateFolding();

        // getSite().setSelectionProvider(sqlViewer);
        getEditorSite().getPage().addSelectionListener(this);

        StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());

        // |bvAbvj[쐬
         hookContextMenu();

        // Xe[^Xo[쐬
        // contributeToStatusLine();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        fAnnotationAccess = getAnnotationAccess();
        fOverviewRuler = createOverviewRuler(getSharedColors());
        // ISourceViewer viewer = new SQLSourceViewer(parent, ruler,
        // getOverviewRuler(), isOverviewRulerVisible(), styles);
        PLSQLSourceViewer viewer = new PLSQLSourceViewer(parent, ruler, getOverviewRuler(), true, styles);
        // modify
        viewer.setPlsqlEditor(this);
        
        getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

     private void hookContextMenu() {
     MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
     menuMgr.setRemoveAllWhenShown(true);
     menuMgr.addMenuListener(new IMenuListener() {
     public void menuAboutToShow(IMenuManager manager) {
     getContributor().fillContextMenu(manager);
     }
     });
     // SourceViewerւ̊蓖ẮATextWidgetɑ΂čs
     StyledText text = sqlViewer.getTextWidget();
     Menu menu = menuMgr.createContextMenu(text);
     text.setMenu(menu);
     getSite().registerContextMenu(menuMgr, sqlViewer);
     }

    private PlsqlEditorContributor getContributor() {
        IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
        if (contributor instanceof PlsqlEditorContributor) {
            return (PlsqlEditorContributor) contributor;
        } else {
            return null;
        }
    }

    public String getEditingSource() {
        return getSourceViewer().getDocument().get();
    }

    protected IStatusLineManager getIStatusLineManager() {
        IEditorSite site = super.getEditorSite();
        IActionBars actionBars = site.getActionBars();
        return actionBars.getStatusLineManager();
    }

    private boolean hasContributionItem(IContributionItem[] items, String targetId) {
        for (int i = 0; i < items.length; i++) {
            IContributionItem item = items[i];
            if (targetId.equals(item.getId())) {
                return true;
            }
        }
        return false;
    }

    // public void contributeToStatusLine() {
    // IStatusLineManager manager = getIStatusLineManager();
    // IContributionItem[] items = manager.getItems();
    // String commitMode = Messages.getString("SqlEditor.1"); //$NON-NLS-1$
    // if (!hasContributionItem(items, commitMode)) {
    // commitModeItem = new StatusLineContributionItem(commitMode);
    // commitModeItem.setText(Messages.getString("SqlEditor.2")); //$NON-NLS-1$
    // manager.add(commitModeItem);
    // }
    // }

    public void dispose() {
        colorManager.dispose();
        getEditorSite().getPage().removeSelectionListener(this);
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (sqlConfiguration != null && sqlViewer != null) {
            sqlConfiguration.updatePreferences(sqlViewer.getDocument());
            StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());
            // LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
            sqlViewer.invalidateTextPresentation();// eLXgGfB^ĕ`
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorInput input = getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fi = (FileEditorInput) input;
            file = fi.getFile();
            this.config = ResourceUtil.getDBConfig(file);
            this.sqlViewer.setDbConfig(this.config);
            getContributor().setActivePage(this);
        }
    }

    protected void setGlobalAction() {
        IActionBars actionbars = getEditorSite().getActionBars();
        actionbars.setGlobalActionHandler(ActionFactory.UNDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.UNDO));
        actionbars.setGlobalActionHandler(ActionFactory.REDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.REDO));
        actionbars.setGlobalActionHandler(ActionFactory.DELETE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.DELETE));
        actionbars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.SELECT_ALL));
        actionbars.setGlobalActionHandler(ActionFactory.COPY.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.COPY));
        actionbars.setGlobalActionHandler(ActionFactory.PASTE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.PASTE));
        actionbars.setGlobalActionHandler(ActionFactory.CUT.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.CUT));
    }

    public void setFocus() {
        setGlobalAction();
    }

    public IDBConfig getConfig() {
        return config;
    }

    public Object getAdapter(Class adapter) {
        if (projectionSupport != null) {
            Object obj = projectionSupport.getAdapter(getSourceViewer(), adapter);
            if (obj != null) {
                return obj;
            }
        }
        return super.getAdapter(adapter);
    }

    private void updateFolding() {
        sqlViewer.updateFolding();

    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        updateFolding();
        clearError();
    }

    public void doSaveAs() {
        super.doSaveAs();
        updateFolding();
        clearError();
    }

    
    // ݖgp(GfB^[̏ꍇ͂̃\bhI[oChăReLXgj[oƂW)
    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add(new Separator());
    }

    public void clearError() {
        try {
            resource.deleteMarkers(null, true, IResource.DEPTH_ZERO);
        } catch (CoreException e) {
            DbPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public PLSQLSourceViewer getPLSQLSourceViewer() {
        return sqlViewer;
    }

    public void setError(OracleSourceErrorInfo[] errors) {
        if (resource != null) {
            try {
                // ݂̑I擾
                StyledText text = getSourceViewer().getTextWidget();
                IDocument doc = getSourceViewer().getDocument();
                
                for (int i = 0; i < errors.length; i++) {
                    OracleSourceErrorInfo info = errors[i];
                    int offset = text.getOffsetAtLine(info.getLine()) + info.getPosition();
                    
                    try {
                        IRegion region = doc.getLineInformation(info.getLine());
                        String str = doc.get(region.getOffset() + info.getPosition()-1, region.getLength());
                        
                        String target = str.replaceAll("\\p{Space}\\p{ASCII}*", "");
                        //String target = str.replaceAll("\\p{Space}.*$", "");
                        
                        ITextSelection selection = new TextSelection(doc, region.getOffset() + info.getPosition()-1, target.length());
                        
                        if (!selection.isEmpty()) {
                            int start = selection.getOffset();
                            int length = selection.getLength();

                            if (length < 0) {
                                length = -length;
                                start -= length;
                            }
                            // }[J[ێ}bv
                            Map attributes = new HashMap();
                            // }[J[̊Jnʒu(CHAR_START)ݒ
                            MarkerUtilities.setCharStart(attributes, start);
                            // }[J[̏Iʒu(CHAR_END)ݒ
                            MarkerUtilities.setCharEnd(attributes, start + length);
                            // }[J[̊Jns(LINE_NUMBER)ݒ
                            int line = selection.getStartLine();
                            MarkerUtilities.setLineNumber(attributes, line == -1 ? -1 : line + 1);
                            // }[J[MESSAGEݒ
                            MarkerUtilities.setMessage(attributes, info.getErrorText());
                            
                            // ̐[x(SEVERITY)ݒ
                            attributes.put(IMarker.SEVERITY, new Integer(IMarker.SEVERITY_ERROR));
                            // ̃}[J[^ŐVǉselection̐ݒ
                            attributes.put("selection", selection.getText() == null ? "" : selection.getText());

                            // }[J[̍쐬
                            MarkerUtilities.createMarker(resource, attributes, "zigen.plugin.db.markers.myProblem");
                        }
                    } catch (BadLocationException e) {
                        e.printStackTrace();
                    }   
                }


            } catch (CoreException e) {
                DbPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }
}
