package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Plsql;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.SelectIntoChecker;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.QueryViewEditor2;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;
import zigen.plugin.db.ui.jobs.AbstractJob.ShowWarningMessageAction;
import zigen.sql.parser.INode;
import zigen.sql.parser.Node;
import zigen.sql.parser.ast.ASTCreateName;
import zigen.sql.parser.ast.ASTCreateStatement;
import zigen.sql.parser.ast.ASTCreateType;

public class ScriptExecJob extends SqlExecJob {

	public ScriptExecJob(Transaction trans, String sqlString, String secondarlyId) {
	    super(trans, sqlString, secondarlyId);
	    super.setName(Messages.getString("ScriptExecJob.0")); //$NON-NLS-1$
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			start();

			if (!trans.isConneting()) {
				Display.getDefault().syncExec(new ConfirmConnectDBAction(trans));
				if (!trans.isConneting()) {
					showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
					return Status.CANCEL_STATUS;
				}
			}

			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}

			executeSingleSQL(trans, sqlString);

			return Status.OK_STATUS;

		} catch (SQLException e) {
			showWarningMessage(e.getMessage());

		} catch (Exception e) {
			showErrorMessage(Messages.getString("SqlExecJob.2"), e); //$NON-NLS-1$

		} finally {
			stop();
			// Ԃ̕\
			// updateResponseTime(getTotalTime());
		}
		return Status.OK_STATUS; // G[_CAO\邽߂OKŕԂ

	}

}
