/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.ExplainForQueryAction;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.AutoCommitModeAction;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.LockDataBaseAction;
import zigen.plugin.db.ui.actions.ManualCommitModeAction;
import zigen.plugin.db.ui.actions.OpenSQLAction;
import zigen.plugin.db.ui.actions.OpenViewAction;
import zigen.plugin.db.ui.actions.PrevSQLExecAction;
import zigen.plugin.db.ui.actions.SaveSQLAction;
import zigen.plugin.db.ui.actions.ShowHistoryViewAction;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.ProjectUtil;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

/**
 * AbstractSQLExecuteViewNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/08/20 ZIGEN create.
 *        [002] 2005/11/23 ZIGEN hbŇɃJ[\ړ悤ɕύX.
 */
public abstract class AbstractSQLExecuteView extends ViewPart implements ITextEditorExtension2, IPropertyChangeListener, ISelectionListener, IStatusChangeListener {

    // private IPartListener fPartListener= new PartAdapter() {
    // // public void partClosed(IWorkbenchPart part) {
    // // System.out.println("partClosed ; " + part.getClass().getName());
    // // if(part instanceof HistoryView){
    // // System.out.println("HistoryView is partClosed");
    // // StatusChangeListener.fireStatusChangeListener(this, SWT.Dispose);
    // // }
    // // }
    // public void partActivated(IWorkbenchPart part) {
    // if(part instanceof AbstractSQLExecuteView){
    // System.out.println("partActivated:" + part.getClass().getName());
    // //setFocus();
    // }
    // }
    //
    // };
    //  
    
	boolean isLockedDataBase = false;

	protected PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();

	protected String lastSelectedDBName;

	public static final String AUTO_COMMIT = Messages.getString("AbstractSQLExecuteView.0"); //$NON-NLS-1$

	public static final String MANUAL_COMMIT = Messages.getString("AbstractSQLExecuteView.1"); //$NON-NLS-1$

	protected String getLastSelectedDBName() {
		Object obj = pluginMgr.getValue(PluginSettingsManager.KEY_DEFAULT_DB);
		if (obj != null) {
			return (String) obj;
		} else {
			return null;
		}
	}

	protected void setLastSelectedDBName(String dbName) {
		pluginMgr.setValue(PluginSettingsManager.KEY_DEFAULT_DB, dbName);
	}

	protected Combo selectCombo;

	protected StatusLineContributionItem commitModeItem;

	protected StatusLineContributionItem positionItem;

	// protected StatusLineContributionItem responseTimeItem;


	protected IDBConfig[] configs;

	protected SQLHistoryManager historyManager = DbPlugin.getDefault().getHistoryManager();

	protected IDBConfig config;

	protected Transaction trans;

	protected SQLSourceViewer sqlViewer;

	protected LineNumberRulerColumn rulerCol;

	protected SQLCodeConfiguration sqlConfiguration;

	protected ColorManager colorManager = new ColorManager();

	protected ImageCacher ic = ImageCacher.getInstance();

	protected MatchingCharacterPainter painter;

	protected CursorLinePainter cpainter;

	protected ExplainForQueryAction explainForQueryAction;

	protected GlobalAction allExecAction = new GlobalAction(null, ISQLOperationTarget.ALL_EXECUTE);
	protected GlobalAction scriptExecAction = new GlobalAction(null, ISQLOperationTarget.SCRIPT_EXECUTE);
	protected GlobalAction allClearAction = new GlobalAction(null, ISQLOperationTarget.ALL_CLEAR);
	protected GlobalAction nextSqlAction = new GlobalAction(null, ISQLOperationTarget.NEXT_SQL);
	protected GlobalAction backSqlAction = new GlobalAction(null, ISQLOperationTarget.BACK_SQL);
	protected GlobalAction formatSqlAction = new GlobalAction(null, ISQLOperationTarget.FORMAT);
	protected GlobalAction commitAction = new GlobalAction(null, ISQLOperationTarget.COMMIT);
	protected GlobalAction rollbackAction = new GlobalAction(null, ISQLOperationTarget.ROLLBACK);
	
    protected OpenSQLAction openAction = new OpenSQLAction(null);
    protected SaveSQLAction saveAction = new SaveSQLAction(null);

    
    protected CommitModeAction ommitModeAction = new CommitModeAction();
    protected ShowHistoryViewAction  showHistoryViewAction = new ShowHistoryViewAction();
    protected IAction lockDataBaseAction = new LockDataBaseAction(this);
    
	IAction currExecAction;

	IAction selectExecAction;

	OpenViewAction openViewAction;

	
	IAction changeSQLDemiliterAction;

	protected void fillLocalToolBar(IToolBarManager manager) {
		//manager.add(new Separator());
		manager.add(showHistoryViewAction);
		manager.add(openViewAction);
        //manager.add(lockDataBaseAction);

		
		// manager.add(new ComboContributionItem("ComboContributionItem"));

	}

	void setEnalbleItem(boolean b) {
		if (allExecAction != null)allExecAction.setEnabled(b);
		if (scriptExecAction != null)scriptExecAction.setEnabled(b);
        if (allClearAction != null)allClearAction.setEnabled(b);
	}

	public void setSqlText(String sql) {
		if (sqlViewer != null)sqlViewer.getDocument().set(sql);
	}

	public IDBConfig getConfig() {
		return config;
	}

	public SourceViewer getSqlViewer() {
		return sqlViewer;
	}

	public SQLHistoryManager getSQLHistoryManager() {
		return historyManager;
	}

	abstract void createToolbarPart(Composite parent);

	public void createContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(sqlViewer.getTextWidget());
		sqlViewer.getTextWidget().setMenu(menu);
		getSite().registerContextMenu(menuMgr, sqlViewer);

		updateHistoryButton();
		contributeToActionBars();

	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(openViewAction);
		//manager.add(new Separator());
		manager.add(lockDataBaseAction);
		
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	void fillContextMenu(IMenuManager manager) {

		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.UNDO));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.REDO));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.CUT));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.COPY));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.PASTE));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.DELETE));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.LINE_DEL));
		manager.add(allClearAction);
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.SELECT_ALL));

		manager.add(new Separator("FIND")); //$NON-NLS-1$
		manager.add((IAction) fGlobalActions.get(ActionFactory.FIND.getId()));

		manager.add(new Separator());
		manager.add(allExecAction);
		manager.add(currExecAction);
		manager.add(selectExecAction);
		manager.add(scriptExecAction);
		
		manager.add(new Separator());
		manager.add(backSqlAction);
		manager.add(nextSqlAction);
		manager.add(new Separator());
		manager.add(commitAction);
		manager.add(rollbackAction);
		manager.add(formatSqlAction);
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.UNFORMAT));
		manager.add(new Separator());
		manager.add(explainForQueryAction);
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.COMMENT));

		// Other plug-ins can contribute there actions here
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));

		manager.add(new Separator());
		manager.add(openViewAction);

	}

	public void createPartControl(Composite parent) {
		Composite header = new Composite(parent, SWT.NONE);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		header.setLayoutData(gridData);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		gridLayout.marginHeight = 1;
		gridLayout.marginWidth = 1;
		gridLayout.horizontalSpacing = 2;
		gridLayout.verticalSpacing = 2;
		header.setLayout(gridLayout);
		Object obj = pluginMgr.getValue(PluginSettingsManager.KEY_DEFAULT_DB);// ۑDB`̂擾
		if (obj != null) {
			this.lastSelectedDBName = (String) obj;
		}
		createToolbarPart(header);
		createSQLInputPart(header);
		makeActions();
		createContextMenu();
		contributeToStatusLine();
		changeTransaction(config);

		initializeFindScopeColor(sqlViewer);

		DbPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this);
		StatusChangeListener.addStatusChangeListener(this);
		// getSite().getPage().addPartListener(fPartListener);

		setExtensionPoint();

	}

	protected void createSQLInputPart(Composite header) {
		Composite body = new Composite(header, SWT.NONE);
		body.setLayoutData(new GridData(GridData.FILL_BOTH));
		body.setLayout(new FillLayout());
		CompositeRuler ruler = new CompositeRuler();
		rulerCol = new LineNumberRulerColumn();
		LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
		ruler.addDecorator(0, rulerCol);
		sqlViewer = new SQLSourceViewer(body, ruler, null, false, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);

		// sqlViewersecondaryId`
		sqlViewer.setSecondaryId(getViewSite().getSecondaryId());
		sqlViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				selectionChangeHandler(event);
			}
		});
		initializeViewerFont(sqlViewer);

		DropTarget target = new DropTarget(sqlViewer.getTextWidget(), DND.DROP_DEFAULT | DND.DROP_COPY | DND.DROP_MOVE | DND.DROP_LINK);
		Transfer[] types = new Transfer[] {
				TreeLeafListTransfer.getInstance(),
				TextTransfer.getInstance(),
				FileTransfer.getInstance()
		};
		target.setTransfer(types);
		target.addDropListener(new DropTreeLeafAdapter(sqlViewer));
		sqlConfiguration = new SQLCodeConfiguration(colorManager);
		sqlViewer.configure(sqlConfiguration);
		sqlViewer.setDocument(new SQLDocument());
		// char[] pair = { '(', ')' };
		ITextViewerExtension2 extension = (ITextViewerExtension2) sqlViewer;
		painter = new MatchingCharacterPainter(sqlViewer, new SQLCharacterPairMatcher());
		painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
		extension.addPainter(painter);

		cpainter = new CursorLinePainter(sqlViewer);
		cpainter.setHighlightColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_CURSOR_LINE));
		sqlViewer.addPainter(cpainter);

		getSite().setSelectionProvider(sqlViewer);
		getViewSite().getPage().addSelectionListener(this);

		StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());

		setGlobalAction();

		sqlViewer.getSelectionProvider().addSelectionChangedListener(selectionChangedListener);
		sqlViewer.addTextListener(textListener);
		sqlViewer.getTextWidget().addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent arg0) {
				updatePosition();
			}

		});

		sqlViewer.getTextWidget().addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent arg0) {
				try {
					updatePosition();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		});

	}

	protected void initializeViewerFont(ISourceViewer viewer) {
		StyledText styledText = viewer.getTextWidget();
		styledText.setFont(DbPlugin.getDefaultFont());
	}

	private void initializeSelectCombo() {
		selectCombo.removeAll();
		configs = DBConfigManager.getDBConfigs();
		for (int i = 0; i < configs.length; i++) {
			IDBConfig w_config = configs[i];
			selectCombo.add(w_config.getSchema() + " : " + w_config.getDbName() + "  "); //$NON-NLS-1$ //$NON-NLS-2$
			if (i == 0)
				selectCombo.select(i);
			if (config == null) {
				if (w_config.getDbName().equals(lastSelectedDBName)) {
					selectCombo.select(i);
					config = w_config;
				}
			} else {
				if (config.getDbName().equals(w_config.getDbName())) {
					pluginMgr.setValue(PluginSettingsManager.KEY_DEFAULT_DB, config.getDbName());
					selectCombo.select(i);
				}
			}

		}
	}

	// OڑDBύXۂɌĂяo
	public final void updateCombo(IDBConfig newConfig) {

		if (this.config != null && isLockedDataBase) {
			// s߂Ăꍇ́Af[^x[X؂ւȂ

			if (this.config.getDbName().equals(newConfig.getDbName())) {
				// s߂ĂꍇłgUNV[h͍Đݒ肷
				setCommitMode(newConfig.isAutoCommit());
			}

			initializeSelectCombo();

		} else {
			this.config = newConfig;
			initializeSelectCombo();
			// N͈config=nullł邽
			// I{bNXIĂ̂ɏ㏑
			if (newConfig == null) {
				int index = selectCombo.getSelectionIndex();
				// \ł-1ɂȂ邽IfŃ`FbN
				if (index >= 0) {
					this.config = configs[index];
				} else {
					// DBCong̐ݒ肪ꍇ
					setEnalbleItem(false); // {^񊈐
					return;
				}
			}
			changeTransaction(getConfig());
		}

	}

	void changeTransaction(IDBConfig config) {
		try {
			if (config != null) {
				trans = Transaction.getInstance(config);
				setEnalbleItem(true); // ACe{^
				if (sqlViewer != null) {
					sqlViewer.setDbConfig(config);
					if (selectCombo != null) {
						ic = ImageCacher.getInstance();
						if (trans.isConneting()) {
							super.setTitleImage(ic.getImage(DbPlugin.IMG_CODE_CONNECTED_DB));
						} else {
							super.setTitleImage(ic.getImage(DbPlugin.IMG_CODE_DB));
						}
					}
				}

				if (commitModeItem != null) {
					setCommitMode(config.isAutoCommit()); // R~bg[h̐ݒ
				}
				
				if(commitAction != null){
				    setCommitMode(config.isAutoCommit()); // R~bg[h̐ݒ
				}

			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	public void dispose() {
		colorManager.dispose();
		getViewSite().getPage().removeSelectionListener(this);
		StatusChangeListener.removeStatusChangeListener(this);

		// gĂ郊Xi[j
		for (Iterator iter = extensionList.iterator(); iter.hasNext();) {
			ISelectionListener listener = (ISelectionListener) iter.next();
			getViewSite().getPage().removeSelectionListener(listener);
		}

		// getSite().getPage().removePartListener(fPartListener);

		fSelectionActions.clear();
		fGlobalActions.clear();

		sqlViewer.getSelectionProvider().removeSelectionChangedListener(selectionChangedListener);
		sqlViewer.removeTextListener(textListener);
		sqlViewer = null;

		super.dispose();
	}

	protected IStatusLineManager getIStatusLineManager() {
		IViewSite vieweSite = super.getViewSite();
		IActionBars actionBars = vieweSite.getActionBars();
		return actionBars.getStatusLineManager();

	}

	public void updatePosition() {
		StringBuffer sb = new StringBuffer();
		try {
			IDocument doc = getSqlViewer().getDocument();
			StyledText text = getSqlViewer().getTextWidget();
			int offset = text.getCaretOffset();
			int line = doc.getLineOfOffset(offset);
			sb.append(doc.getLineOfOffset(offset) + 1);
			sb.append(" : ");
			sb.append(offset - doc.getLineOffset(line) + 1);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}

		positionItem.setText(sb.toString());
	}

	public void contributeToStatusLine() {
		IStatusLineManager manager = getIStatusLineManager();
		commitModeItem = new StatusLineContributionItem("CommitMode"); //$NON-NLS-1$
		commitModeItem.setText(MANUAL_COMMIT); //$NON-NLS-1$
		manager.add(commitModeItem);

		positionItem = new StatusLineContributionItem("Position"); //$NON-NLS-1$
		positionItem.setText("");
		manager.add(positionItem);
	}

	public void setStatusMessage(String message) {
		getIStatusLineManager().setMessage(message);
	}

	public void setStatusErrorMessage(String message) {
		getIStatusLineManager().setErrorMessage(message);
	}

	public void propertyChange(PropertyChangeEvent event) {
		if (sqlConfiguration != null && sqlViewer != null) {
			StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());
			LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
			sqlConfiguration.updatePreferences(sqlViewer.getDocument());
			painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
			cpainter.setHighlightColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_CURSOR_LINE));

			// ύXL[ɂĔfύX
			String property = event.getProperty();
			if (SQLEditorPreferencePage.P_COLOR_FIND_SCOPE.equals(property)) {
				initializeFindScopeColor(sqlViewer);
			}

			sqlViewer.invalidateTextPresentation();// eLXgGfB^ĕ`

		}
		if (event.getProperty().equals(PreferencePage.P_MAX_HISTORY)) {
			historyManager.removeOverHistory();
		}
	}

	abstract void selectionChangeHandler(SelectionChangedEvent event);

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
	    if (selection != null && selection instanceof StructuredSelection) {
			Object obj = ((StructuredSelection) selection).getFirstElement();
			if (obj != null) {
				IDBConfig config = null;

				if (obj instanceof IAdaptable) {
					IAdaptable adaptable = (IAdaptable) obj;
					Object o = adaptable.getAdapter(IResource.class);

					if (o instanceof IProject) {
						config = ProjectUtil.getDBConfig((IProject) o);
					} else if (o instanceof IFolder) {
						config = ResourceUtil.getDBConfig((IFolder) o);
					} else if (o instanceof IFile){
						config = ResourceUtil.getDBConfig((IFile) o);
					}

				} else if (obj instanceof TreeNode) {
					config = ((TreeNode) obj).getDbConfig();
				}

				if (config != null)
					updateCombo(config);


			}

		}

	}

	public String getSecondarlyId() {
		return getViewSite().getSecondaryId();
	}

	public void setFocus() {
		if (sqlViewer != null) {
			sqlViewer.getControl().setFocus();
			// FocusɃV[gJbgLɂ
			setGlobalAction();

		}
		// sr[݂Ύs{^Ԃɂ
		IViewPart view = DbPlugin.findView(DbPluginConstant.VIEW_ID_HistoryView);
		if (showHistoryViewAction != null) {
			if (view != null) {
				showHistoryViewAction.setChecked(true);
			} else {
				showHistoryViewAction.setChecked(false);
			}
		}
		StatusChangeListener.fireStatusChangeListener(this, SWT.Selection);

	}

	/**
	 * {^̗Lݒ OActionĂ΂܂
	 */
	public final void updateHistoryButton() {
		// O{^
		if (historyManager.hasPrevHistory()) {
			if (backSqlAction != null)
				backSqlAction.setEnabled(true);
		} else {
			if (backSqlAction != null)
				backSqlAction.setEnabled(false);
		}
		// {^
		if (historyManager.hasNextHistory()) {
			if (nextSqlAction != null)
				nextSqlAction.setEnabled(true);
		} else {
			if (nextSqlAction != null)
				nextSqlAction.setEnabled(false);
		}
	}

	// OĂяo
	public void setCommitMode(boolean autoCommit) {
		String text = autoCommit ? AUTO_COMMIT : MANUAL_COMMIT;
		if(commitAction != null)commitAction.setEnabled(!autoCommit);
		if(rollbackAction != null)rollbackAction.setEnabled(!autoCommit);		
		if(config != null)config.setAutoCommit(autoCommit); // IDBConfigɑ΂R~bg[h̐ݒ
		if(openViewAction != null)openViewAction.setDbConfig(config); // openViewActionDBConfigݒ
		
		if(commitModeItem != null)commitModeItem.setText(text);
		if(ommitModeAction != null)ommitModeAction.setCommitMode(autoCommit);

	}

	abstract public void statusChanged(Object obj, int status);


	protected void makeActions() {

		// for Toolbar
        openAction.setSQLSourceViewer(sqlViewer);
        saveAction.setSQLSourceViewer(sqlViewer);
        
		allExecAction.setTextViewer(sqlViewer);
        scriptExecAction.setTextViewer(sqlViewer);
        nextSqlAction.setTextViewer(sqlViewer);
        backSqlAction.setTextViewer(sqlViewer);
        formatSqlAction.setTextViewer(sqlViewer);
        commitAction.setTextViewer(sqlViewer);
        rollbackAction.setTextViewer(sqlViewer);
        allClearAction.setTextViewer(sqlViewer);
        
        
		currExecAction = new GlobalAction(sqlViewer, ISQLOperationTarget.CURRENT_EXECUTE);
		selectExecAction = new GlobalAction(sqlViewer, ISQLOperationTarget.SELECTED_EXECUTE);
		
		explainForQueryAction = new ExplainForQueryAction(this);
		openViewAction = new OpenViewAction(getViewSite().getWorkbenchWindow());
		

	}

	protected Color fFindScopeHighlightColor;

	protected Map fGlobalActions = new HashMap();

	protected List fSelectionActions = new ArrayList();

	private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener() {
		public void selectionChanged(SelectionChangedEvent event) {
			updateSelectionDependentActions();
		}
	};

	private ITextListener textListener = new ITextListener() {
		public void textChanged(TextEvent event) {
			IUpdate findReplace = (IUpdate) fGlobalActions.get(ActionFactory.FIND.getId());
			if (findReplace != null) {
				findReplace.update();
			}

		}
	};

	protected void updateSelectionDependentActions() {
		Iterator iterator = fSelectionActions.iterator();
		while (iterator.hasNext()) {
			updateAction((String) iterator.next());
		}
	}

	protected void updateAction(String actionId) {
		IAction action = (IAction) fGlobalActions.get(actionId);
		if (action instanceof IUpdate) {
			((IUpdate) action).update();
		}
	}

	protected void setGlobalAction() {
		IActionBars actionBars = getViewSite().getActionBars();
		ResourceBundle bundle = DbPlugin.getDefault().getResourceBundle();

		setGlobalAction(actionBars, ActionFactory.UNDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.UNDO));
		setGlobalAction(actionBars, ActionFactory.REDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.REDO));
		setGlobalAction(actionBars, ActionFactory.DELETE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.DELETE));
		setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.SELECT_ALL));
		setGlobalAction(actionBars, ActionFactory.COPY.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.COPY));
		setGlobalAction(actionBars, ActionFactory.PASTE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.PASTE));
		setGlobalAction(actionBars, ActionFactory.CUT.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.CUT));
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLExecuteAction", allExecAction); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLCurrentExecuteAction", currExecAction); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLSelectedExecuteAction", selectExecAction); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLBackAction", backSqlAction); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLNextAction", nextSqlAction); //$NON-NLS-1$

		FindReplaceAction findReplaceAction = new FindReplaceAction(bundle, "find_replace_action_", this); //$NON-NLS-1$
		findReplaceAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.FIND_REPLACE);

		setGlobalAction(actionBars, ActionFactory.FIND.getId(), findReplaceAction); //$NON-NLS-1$

		fSelectionActions.add(ActionFactory.CUT.getId());
		fSelectionActions.add(ActionFactory.COPY.getId());
		fSelectionActions.add(ActionFactory.PASTE.getId());
		fSelectionActions.add(ActionFactory.FIND.getId());

		actionBars.updateActionBars();
	}

	protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
		fGlobalActions.put(actionID, action);
		actionBars.setGlobalActionHandler(actionID, action);
	}

	public Object getAdapter(Class required) {

		if (IFindReplaceTarget.class.equals(required)) {
			IFindReplaceTarget target = sqlViewer.getFindReplaceTarget();
			if (target instanceof IFindReplaceTargetExtension) {
				IFindReplaceTargetExtension t = (IFindReplaceTargetExtension) target;
				if (fFindScopeHighlightColor != null)
					t.setScopeHighlightColor(fFindScopeHighlightColor);
			}

			return target;
		}
		if (Widget.class.equals(required)) {
			return sqlViewer.getTextWidget();
		}
		return null;
	}

	// ITextEditorExtension2
	public boolean isEditorInputModifiable() {
		return true;
	}

	// ITextEditorExtension2
	public boolean validateEditorInputState() {
		return true;
	}

	private void initializeFindScopeColor(ISourceViewer viewer) {
		IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
		if (store != null) {
			// StyledText styledText= viewer.getTextWidget();
			Color color = colorManager.getColor(SQLEditorPreferencePage.P_COLOR_FIND_SCOPE);
			IFindReplaceTarget target = viewer.getFindReplaceTarget();
			if (target != null && target instanceof IFindReplaceTargetExtension)
				((IFindReplaceTargetExtension) target).setScopeHighlightColor(color);

			if (fFindScopeHighlightColor != null)
				fFindScopeHighlightColor.dispose();

			fFindScopeHighlightColor = color;
		}
	}

	public boolean isLockedDataBase() {
		return isLockedDataBase;
	}

	public void setLockedDataBase(boolean isLockedDataBase) {
		this.isLockedDataBase = isLockedDataBase;
	}

	private List extensionList = new ArrayList();

	private void setExtensionPoint() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		// g|Cg擾
		IExtensionPoint point = registry.getExtensionPoint(DbPlugin.getDefault().getBundle().getSymbolicName() + ".selection");
		// Rgr[gꂽg擾
		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				if (elements[j].getName().equals("contributor")) {
					try {
						// classŎw肳ꂽNX
						ISelectionListener listener = (ISelectionListener) elements[j].createExecutableExtension("class");
						getViewSite().getPage().addSelectionListener(listener);
						extensionList.add(listener);
					} catch (Exception ex) {
						ex.printStackTrace();
					}
				}
			}
		}

	}
    void autoCommitSelectHandler() {
        if (ommitModeAction.isAutoCommit()) {
            // R~bg̏ꍇ́AR~bgA[obN{^͔񊈐
            if (trans == null || trans.getTransactionCount() == 0) {
                setCommitMode(true);
            } else {
                // [obN̊mF_CAON
                DbPlugin.getDefault().showWarningMessage(Messages.getString("SQLExecuteView.7")); //$NON-NLS-1$
                setCommitMode(false);
            }
        } else {
            setCommitMode(false);
        }
        // SĂSQLsr[ɒʒmAR~bg[h킹
        StatusChangeListener.fireStatusChangeListener(this, StatusChangeListener.EVT_ChangeTransactionMode);
    }
    
    class CommitModeAction extends Action implements IMenuCreator {
        Menu fMenu;
        Action autoAction;
        Action manualAction;
        boolean isAutoCommit = false;
        
        CommitModeAction() {
            super("R~bg[h", Action.AS_DROP_DOWN_MENU);
            setMenuCreator(this);
            setCommitMode((config == null)? false : config.isAutoCommit());
            
        }

        public void run() {
            // {^gƂ̃ANV
            isAutoCommit = !isAutoCommit;
            setCommitMode(isAutoCommit);
            autoCommitSelectHandler();
        }

        public void dispose() {
        }

        public Menu getMenu(final Control parent) {
            fMenu = new Menu(parent);

            autoAction = new Action("Auto Commit", IAction.AS_CHECK_BOX) {
                public void run() {
                    if(!isAutoCommit){
                        isAutoCommit = !isAutoCommit;
                        setCommitMode(isAutoCommit);
                        autoCommitSelectHandler();
                    }
                }
            };
            autoAction.setChecked(isAutoCommit);
            autoAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_AUTO));
            
            addActionToMenu(fMenu, autoAction);
            manualAction = new Action("Manual Commit", IAction.AS_CHECK_BOX) {
                public void run() {
                    if(isAutoCommit){
                        isAutoCommit = !isAutoCommit;
                        setCommitMode(isAutoCommit);
                        autoCommitSelectHandler();
                    }
                }
            };
            manualAction.setChecked(!isAutoCommit);
            manualAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_MANUAL));
            addActionToMenu(fMenu, manualAction);

            return fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, IAction action) {
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(parent, -1);
        }

        
        public final void setCommitMode(boolean _isAutoCommit){
            this.isAutoCommit = _isAutoCommit;
            if(_isAutoCommit){
                setToolTipText("Auto Commit");
                setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_AUTO));
            }else{
                setToolTipText("Manual Commit");
                setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_MANUAL));
            }
            
            
            if(config != null){
                config.setAutoCommit(_isAutoCommit);
//                System.out.println("R~bg[h(R~bg)H " + config.isAutoCommit());
            }else{
//                System.out.println("config is null");
            }
            
        }
        public boolean isAutoCommit(){
            return isAutoCommit;
        }

    }
}
