/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.bookmark.DragBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.DropBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;

/**
 * TreeViewNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/11/27 ZIGEN create.
 */
public abstract class AbstractTreeView extends ViewPart implements IStatusChangeListener {


	protected PluginSettingsManager settringMgr = DbPlugin.getDefault().getPluginSettingsManager();


	protected int maxSize = 20;

	protected TreeViewer viewer;

	protected Combo filterComb;

	protected Button searchBtn;

	protected List filterHistory;
	
	//protected boolean fLinkingEnabled;

	public void setLinkingEnabled(boolean enabled) {
		//fLinkingEnabled = enabled;
		settringMgr.setValue(PluginSettingsManager.KEY_LINKED_EDITOR, new Boolean(enabled));
	}

	public boolean isLinkingEnabled() {
		//return fLinkingEnabled;
		Boolean b = (Boolean)settringMgr.getValue(PluginSettingsManager.KEY_LINKED_EDITOR);
		return (b == null) ? false  : b.booleanValue();
	}

	
	public void createPartControl(Composite parent) {

		Composite main = new Composite(parent, SWT.NONE);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		main.setLayoutData(gridData);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		gridLayout.marginHeight = 2;
		gridLayout.marginWidth = 0;
		gridLayout.horizontalSpacing = 0;
		gridLayout.verticalSpacing = 2;
		main.setLayout(gridLayout);
		//      

		createFilterBar(main);

		createTreeArea(main);

		// SelectionProviderɓo^(ύXʒm邽߁j
		getSite().setSelectionProvider(viewer);
		makeActions();
		hookContextMenu();

		hookDoubleClickAction();
		contributeToActionBars();

		//setGlobalAction(getViewSite().getActionBars());

		StatusChangeListener.addStatusChangeListener(this);
	}

	protected void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	protected void hookDoubleClickAction() {
		// DoubleClickHandler̒ǉ
		viewer.addDoubleClickListener(new TreeDoubleClickHandler());
	}

	// <!-- [002] ǉ ZIGEN 2005/06/02
	protected void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	abstract void makeActions();

	abstract void fillContextMenu(IMenuManager manager);

	abstract void fillLocalPullDown(IMenuManager manager);

	abstract void fillLocalToolBar(IToolBarManager manager);

	abstract void setGlobalAction(IStructuredSelection selection);

	/**
	 * IꂽvfɂAction#setEnableݒ肷
	 * 
	 * @param event
	 */
	abstract void selectionChangeHandler(SelectionChangedEvent event);

	protected TreeContentProvider contentProvider;

	protected void createTreeArea(Composite parent) {
		Composite body = new Composite(parent, SWT.NONE);
		body.setLayoutData(new GridData(GridData.FILL_BOTH));
		body.setLayout(new FillLayout());

		viewer = new TreeViewer(body, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

		// DragCxg̎
		// int dragOption = DND.DROP_COPY | DND.DROP_MOVE;
		// Transfer[] transfers = new Transfer[] { TextTransfer.getInstance() };
		// viewer.addDragSupport(dragOption, transfers, new
		// DragElementAdapter(viewer));

		int dragOption = DND.DROP_DEFAULT | DND.DROP_MOVE | DND.DROP_COPY;
		Transfer[] transfers = new Transfer[] {
			TreeLeafListTransfer.getInstance()
		};
		viewer.addDragSupport(dragOption, transfers, new DragBookmarkAdapter(viewer));
		viewer.addDropSupport(dragOption, transfers, new DropBookmarkAdapter(viewer));

		contentProvider = new TreeContentProvider();
		viewer.setContentProvider(contentProvider);
		viewer.setLabelProvider(new TreeLabelProvider());
		viewer.setSorter(new TreeViewSorter());
		viewer.setInput(getViewSite());
		// viewer.expandAll(); // ׂēWJԂƂ
		viewer.expandToLevel(2); // 2Kwڂ܂œWJꍇ

		// Listener̒ǉ(XL[}WJɃe[uj
		viewer.addTreeListener(new TreeViewListener());

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				selectionChangeHandler(event);
			}
		});

	}

	protected ToolItem targetSchema;

	protected ToolItem targetTable;

	protected ToolItem targetColumn;

	protected ImageCacher ic = ImageCacher.getInstance();

	protected void createFilterBar(Composite parent) {
		GridData gridData;
		final Composite tool = new Composite(parent, SWT.NONE);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		tool.setLayoutData(gridData);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 4;
		gridLayout.makeColumnsEqualWidth = false;
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.horizontalSpacing = 0;
		gridLayout.verticalSpacing = 0;
		tool.setLayout(gridLayout);

		Label label1 = new Label(tool, SWT.NULL);
		gridData = new GridData(GridData.FILL);
		label1.setLayoutData(gridData);
		label1.setText(" Filter:"); //$NON-NLS-1$

		// c[o[
		ToolBar toolbar = new ToolBar(tool, SWT.FLAT);

		targetSchema = new ToolItem(toolbar, SWT.CHECK);
		targetSchema.setImage(ic.getImage(DbPlugin.IMG_CODE_SCHEMA));
		targetSchema.setToolTipText(Messages.getString("AbstractTreeView.4")); //$NON-NLS-1$
		targetSchema.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				targetTable.setSelection(false);
				targetColumn.setSelection(false);

				filter(filterComb.getText());
			}
		});

		targetTable = new ToolItem(toolbar, SWT.CHECK);
		targetTable.setImage(ic.getImage(DbPlugin.IMG_CODE_TABLE));
		targetTable.setToolTipText(Messages.getString("AbstractTreeView.3")); //$NON-NLS-1$
		targetTable.setSelection(true);// ftHgTrue
		targetTable.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				targetSchema.setSelection(false);
				targetColumn.setSelection(false);
				filter(filterComb.getText());
			}
		});

		targetColumn = new ToolItem(toolbar, SWT.CHECK);
		targetColumn.setImage(ic.getImage(DbPlugin.IMG_CODE_COLUMN));
		targetColumn.setToolTipText(Messages.getString("AbstractTreeView.2")); //$NON-NLS-1$
		targetColumn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				targetSchema.setSelection(false);
				targetTable.setSelection(false);
				filter(filterComb.getText());
			}
		});

		filterComb = new Combo(tool, SWT.NONE);
		filterComb.setVisibleItemCount(20);
		filterComb.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		filterComb.setText(""); //$NON-NLS-1$

		filterComb.addFocusListener(new TextSelectionListener());
		filterComb.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if (e.character == SWT.CR) {
					e.doit = false;
					filter(filterComb.getText());
				}
			}
		});

		searchBtn = new Button(tool, SWT.NONE);
		searchBtn.setText(Messages.getString("AbstractTreeView.6")); //$NON-NLS-1$

		searchBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				filter(filterComb.getText());
			}

		});

		filterHistory = loadFilterHistory();

		// ꗗ̍쐬
		if (filterHistory != null) {
			for (int i = 0; i < filterHistory.size(); i++) {
				filterComb.add((String) filterHistory.get(i));
			}
		}
	}

	private void filter(String condition) {

		boolean schema = targetSchema.getSelection();
		boolean table = targetTable.getSelection();
		boolean column = targetColumn.getSelection();

		for (int i = 0; i < viewer.getFilters().length; i++) {
			ViewerFilter filter = viewer.getFilters()[i];
			viewer.removeFilter(filter);
		}

		if (!"".equals(condition)) { //$NON-NLS-1$
			viewer.addFilter(new TreeViewTableFilter(condition, schema, table, column));
		}

		// vx폜AŏʂɈړ
		if (filterHistory.contains(condition)) {
			filterHistory.remove(condition);
			filterComb.remove(condition);
		}
		filterHistory.add(0, condition); // 擪ɒǉ
		filterComb.add(condition, 0); // 擪ɒǉ
		filterComb.select(0);// 擪I
		// ől𒴂폜
		removeOverHistory();

		filterComb.setFocus();
	}

	private void removeOverHistory() {
		while (filterHistory.size() > maxSize) { // 󔒗pl
			int i = filterHistory.size() - 1;
			filterHistory.remove(i);
			filterComb.remove(i);
		}
	}

	public void dispose() {
		StatusChangeListener.removeStatusChangeListener(this);
		saveFilterHistory();
	}

	private void saveFilterHistory() {
		settringMgr.setValue(PluginSettingsManager.KEY_FILTER_LIST, filterHistory);
	}

	private List loadFilterHistory() {
		List list = (List) settringMgr.getValue(PluginSettingsManager.KEY_FILTER_LIST);
		if (list != null) {
			return list;
		} else {
			return new ArrayList();
		}
	}

	public TreeContentProvider getContentProvider() {
		return contentProvider;
	}

	public TreeViewer getTreeViewer() {
		return viewer;
	}

	protected IDBConfig currentIDBConfig;
	public void setStatusMessage(IDBConfig currentIDBConfig, String message) {
		this.currentIDBConfig = currentIDBConfig;
		getIStatusLineManager().setMessage(message);
	}

	public void setStatusErrorMessage(IDBConfig currentIDBConfig, String message) {
		this.currentIDBConfig = currentIDBConfig;
		getIStatusLineManager().setErrorMessage(message);
	}
	protected IStatusLineManager getIStatusLineManager() {
		IViewSite vieweSite = super.getViewSite();
		IActionBars actionBars = vieweSite.getActionBars();
		return actionBars.getStatusLineManager();

	}
}
