/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.ShowHistoryViewAction;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SQLExecuteView extends AbstractSQLExecuteView {

    public void createToolbarPart(final Composite parent) {
        CoolBar coolBar = new CoolBar(parent, SWT.FLAT);
        CoolBarManager coolBarMgr = new CoolBarManager(coolBar);
        GridData gid = new GridData();
        gid.horizontalAlignment = GridData.FILL;
        coolBar.setLayoutData(gid);

        ToolBarManager toolBarMgr1 = new ToolBarManager(SWT.FLAT);
        toolBarMgr1.add(allExecAction);
        toolBarMgr1.add(scriptExecAction);
        toolBarMgr1.add(allClearAction);

        ToolBarManager toolBarMgr2 = new ToolBarManager(SWT.FLAT);
        toolBarMgr2.add(backSqlAction);
        toolBarMgr2.add(nextSqlAction);

        ToolBarManager toolBarMgr3 = new ToolBarManager(SWT.FLAT);
        toolBarMgr3.add(ommitModeAction);
        toolBarMgr3.add(commitAction);
        toolBarMgr3.add(rollbackAction);


        ToolBarManager toolBarMgr4 = new ToolBarManager(SWT.FLAT);
        toolBarMgr4.add(formatSqlAction);
        //toolBarMgr4.add(showHistoryViewAction);
        
        ToolBarManager toolBarMgr6 = new ToolBarManager(SWT.FLAT);
        toolBarMgr6.add(openAction);
        toolBarMgr6.add(saveAction);
        
        ToolBarManager toolBarMgr5 = new ToolBarManager(SWT.FLAT);
        toolBarMgr5.add(new ComboContributionItem("SelectDataBase"));
        toolBarMgr5.add(lockDataBaseAction);
        

        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr6));
        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr1));
        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr2));
        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr3));
        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr4));
        coolBarMgr.add(new ToolBarContributionItem(toolBarMgr5));
        coolBarMgr.update(true);

        coolBar.addControlListener(new ControlListener() {
            public void controlMoved(ControlEvent e) {
            }
            public void controlResized(ControlEvent e) {
                parent.getParent().layout(true);
                parent.layout(true);
            }
        });



    }

    public class ComboContributionItem extends ControlContribution {
        public ComboContributionItem(String id) {
            super(id);
        }
        protected Control createControl(Composite parent) {
            selectCombo = new Combo(parent, SWT.READ_ONLY);
            GridData data = new GridData(GridData.FILL_HORIZONTAL);
            data.widthHint = 200;
            selectCombo.setLayoutData(data);
            updateCombo(null); // N̏ꍇNULL
            selectCombo.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    int index = selectCombo.getSelectionIndex();
                    config = configs[index];
                    setLastSelectedDBName(config.getDbName());
                    changeTransaction(config);
                }
            });

            return selectCombo;
        }
    }

    public void selectionChangeHandler(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection) selection;
            // executeSelectedSQLAction.setSelection(textSelection);

            if (textSelection.getLength() > 0) {
                // executeSelectedSQLAction.setEnabled(true);
                if (config != null && config.getDbType() == DBType.DB_TYPE_ORACLE) {
                    explainForQueryAction.setEnabled(true);// Oraclê݁usvv̎s\
                }
            } else {
                // executeSelectedSQLAction.setEnabled(false);
                explainForQueryAction.setEnabled(false);
            }

        } else {
            // executeSelectedSQLAction.setSelection(null);
            // executeSelectedSQLAction.setEnabled(false);
            explainForQueryAction.setEnabled(false);
        }
    }

    public void statusChanged(Object obj, int status) {
        if (obj instanceof HistoryView) {
            switch (status) {
                case SWT.Selection:
                    if (showHistoryViewAction != null)
                        showHistoryViewAction.setChecked(true);
                    break;
                case SWT.Dispose:
                    if (showHistoryViewAction != null)
                        showHistoryViewAction.setChecked(false);
                    break;
                case StatusChangeListener.EVT_UpdateHistory: // SQL{^XV
                    updateHistoryButton();
                    break;
                default:
                    break;
            }

        } else if (obj instanceof SQLExecuteView) {
            SQLExecuteView view = (SQLExecuteView) obj;
            switch (status) {
                case StatusChangeListener.EVT_ChangeTransactionMode: // R~bg[hύX
                    updateCombo(view.config);
                    break;
                default:
                    break;
            }

        } else if (obj instanceof SQLSourceViewer) {
            switch (status) {
                case StatusChangeListener.EVT_UpdateHistory: // SQL{^XV
                    updateHistoryButton();
                    break;
                default:
                    break;
            }

        } else if (obj instanceof IDBConfig) {

            if (status == StatusChangeListener.EVT_ChangeDataBase) {
                updateCombo((IDBConfig) obj);
            }
        }
    }

}
