/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.diff;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

import zigen.plugin.db.DbPlugin;

/**
 * TableEditorNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 * 
 */
public class DDLDiffEditor extends EditorPart {

	private IDDLDiff[] diffs;

	private DDLDiffViewer diffviewer;

	private TreeViewer treeViewer;

	private SashForm sash;

	private boolean isTableDiff = false;

	public static final String ID = "zigen.plugin.db.diff.DDLDiffEditor"; //$NON-NLS-1$

	public DDLDiffEditor() {
		super();

	}

	public boolean isDirty() {
		return false;
	}

	public void createPartControl(Composite parent) {
		CompareConfiguration cc = new CompareConfiguration();

		if (!isTableDiff) {
			sash = new SashForm(parent, SWT.VERTICAL | SWT.NONE);
			treeViewer = new TreeViewer(sash, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.FLAT);
			treeViewer.setContentProvider(new DiffContentProvider());
			treeViewer.setLabelProvider(new DDLLabelProvider());
			treeViewer.setInput(diffs);

			Composite body = new Composite(sash, SWT.BORDER | SWT.FLAT);

			body.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 1;
			gridLayout.makeColumnsEqualWidth = false;
			gridLayout.marginHeight = 1;
			gridLayout.marginWidth = 1;
			gridLayout.horizontalSpacing = 2;
			gridLayout.verticalSpacing = 2;
			body.setLayout(gridLayout);

			ToolBar toolBar = new ToolBar(body, SWT.FLAT);
			// toolBar.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			toolBar.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
			ToolBarManager toolBarManager = new ToolBarManager(toolBar);

			Composite lower = new Composite(body, SWT.BORDER | SWT.FLAT);
			lower.setLayout(new FillLayout(SWT.HORIZONTAL));
			lower.setLayoutData(new GridData(GridData.FILL_BOTH));
			diffviewer = new DDLDiffViewer(lower, cc);
			diffviewer.addToolItems(toolBarManager);

			diffviewer.setContentProvider(new DDLDiffContentProvider(cc));
			if (diffs != null && diffs.length >= 1) {
				diffviewer.setInput(diffs[0]);
			}

			treeViewer.addSelectionChangedListener(new DiffTreeSelectionHandler(this));

			// ŏ̍ڂIԂɂ
			TreeItem topItem = treeViewer.getTree().getTopItem();
			treeViewer.getTree().setSelection(new TreeItem[] {
				topItem
			});

			sash.setWeights(new int[] {
					30,
					70
			});

			// c[o[XV
			toolBarManager.update(true);

		} else {

			parent.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 1;
			gridLayout.makeColumnsEqualWidth = false;
			gridLayout.marginHeight = 1;
			gridLayout.marginWidth = 1;
			gridLayout.horizontalSpacing = 2;
			gridLayout.verticalSpacing = 2;
			parent.setLayout(gridLayout);

			ToolBar toolBar = new ToolBar(parent, SWT.FLAT);
			// toolBar.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			toolBar.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));

			ToolBarManager toolBarManager = new ToolBarManager(toolBar);

			Composite lower = new Composite(parent, SWT.BORDER | SWT.FLAT);
			lower.setLayout(new FillLayout(SWT.HORIZONTAL));
			lower.setLayoutData(new GridData(GridData.FILL_BOTH));
			diffviewer = new DDLDiffViewer(lower, cc);
			diffviewer.addToolItems(toolBarManager);
			diffviewer.setContentProvider(new DDLDiffContentProvider(cc));

			if (diffs != null && diffs.length >= 1) {
				diffviewer.setInput(diffs[0]);
			}

			// c[o[XV
			toolBarManager.update(true);
		}

	}

	private IToolBarManager getToolBarManager() {
		return getEditorSite().getActionBars().getToolBarManager();

	}

	public void dispose() {
		super.dispose();
	}

	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public boolean isSaveAsAllowed() {
		return false;
	}

	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		try {
			setSite(site);
			setInput(editorInput);

			if (editorInput instanceof DDLDiffEditorInput) {
				DDLDiffEditorInput input = (DDLDiffEditorInput) editorInput;
				diffs = input.getDiffs();
				isTableDiff = input.isTableDiff();
			}

		} catch (Exception e) {
			DbPlugin.log(e);
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	public void setFocus() {
	}

	public TreeViewer getTreeViewer() {
		return treeViewer;
	}

	public DDLDiffViewer getDiffviewer() {
		return diffviewer;
	}

	public SashForm getSash() {
		return sash;
	}
}
