/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ui.editors.internal;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.OracleColumn;

public class ColumnFilterInfo {
	private Column col;

	private TableColumn tCol;

	private boolean checked = true; // ltrueƂ

	public ColumnFilterInfo(Column col) {
		this.col = col;
		this.tCol = col.getColumn();
	}

	public boolean isChecked() {
		return checked;
	}

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public String getColumnName() {
		return tCol.getColumnName();
	}

	public String getTypeName() {
		return tCol.getTypeName().toLowerCase();
	}

	public String getSize() {
		return col.getSize();
	}

	public boolean isNotNull() {
		return tCol.isNotNull();
	}

	public boolean isPrimaryKey() {
		return (col.getPkColumn() != null);
	}

	public String getDefaultValue() {
		return tCol.getDefaultValue();
	}

	public String getCommentName() {
		if (col instanceof OracleColumn) {
			return ((OracleColumn) col).getColumn().getRemarks();
		} else {
			return col.getRemarks();
		}
	}
	
	// яw
	private int sortNo = 0;
	
	private boolean isDesc = false;

	public int getSortNo() {
		return sortNo;
	}

	public void setSortNo(int sortNo) {
		this.sortNo = sortNo;
	}

	public boolean isDesc() {
		return isDesc;
	}

	public void setDesc(boolean isDesc) {
		this.isDesc = isDesc;
	}
	

}
