/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ui.editors.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.jface.viewers.TableViewer;

import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;

/**
 * TableViewerManagerNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/09/17 ZIGEN create.
 * 
 */
public class TableViewerManager {

	/**
	 * vfǉ
	 * 
	 * @param viewer
	 * @param newElement
	 */
	public static void insert(TableViewer viewer, TableElement newElement) {

		Object obj = viewer.getInput();

		if (obj instanceof TableElement[]) {
			TableElement[] old = (TableElement[]) viewer.getInput();

			TableElement[] wk = new TableElement[old.length + 1];
			System.arraycopy(old, 0, wk, 0, old.length);

			// ŌɐVKElementǉ
			wk[old.length] = newElement;

			// viewerɒǉElementZbg
			viewer.setInput(wk);

		} else {
			throw new IllegalArgumentException("TableViewerɊi[ĂIuWFNgقȂ܂"); //$NON-NLS-1$
		}
	}

	/**
	 * w肵vfXV sXVꂽꍇłAۂɍXVŝݍĕ`悳
	 * 
	 * @param viewer
	 * @param from
	 * @param to
	 */
	public static void update(TableViewer viewer, TableElement from, TableElement to) {
		
		Object obj = viewer.getInput();
		TimeWatcher tw = new TimeWatcher();
		tw.start();
		if (obj instanceof TableElement[]) {
			TableElement[] elements = (TableElement[]) viewer.getInput();
			for (int i = 1; i < elements.length; i++) {
				if (elements[i].equals(from)) {
					TableElement ele = elements[i];
					ele.copy(to);
					ele.clearMofiedColumn();
					ele.setRecordNo(i); // 1Ԗڂ̓wb_[
					ele.isNew(false);
					viewer.update(ele, null);// e[uEr[XV
					break; // XVsbreak
				}
			}
		} else {
			throw new IllegalArgumentException("TableViewerɊi[ĂIuWFNgقȂ܂"); //$NON-NLS-1$
		}
		tw.stop();
	}

	/**
	 * w肵vf폜
	 * 
	 * @param viewer
	 * @param from
	 * @param to
	 */
	public static void remove(TableViewer viewer, Object target) {
		Object obj = viewer.getInput();

		if (obj instanceof TableElement[]) {
			TableElement[] elements = (TableElement[]) viewer.getInput();

			List newList = new ArrayList();
			for (int i = 0; i < elements.length; i++) {
				if (!elements[i].equals(target)) {
					// svElement̂ݒǉ
					newList.add(elements[i]);
				}
			}
			// viewerɐVElementZbg
			viewer.setInput((TableElement[]) newList.toArray(new TableElement[0]));

			// TableViewerĕ`
			// viewer.refresh();

		} else {
			throw new IllegalArgumentException("TableViewerɊi[ĂIuWFNgقȂ܂"); //$NON-NLS-1$
		}
	}
	
	/**
	 * w肵̗vf폜
	 * @param viewer
	 * @param target
	 */
    public static void remove(TableViewer viewer, Object[] target) {
    	TableElement[] contents = (TableElement[]) viewer.getInput();
    	
        LinkedList srcList = new LinkedList(Arrays.asList(contents));
        for (int i = 0; i < target.length; i++) {
            srcList.remove(target[i]);
        }
        contents = (TableElement[])srcList.toArray(new TableElement[srcList.size()]);

        viewer.setInput(contents);
    }



}
