/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ui.editors.sql;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;

import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.views.ISQLOperationTarget;

/**
 * TableViewerContributorNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 * 
 */
//public class SqlEditorContributor extends MultiPageEditorActionBarContributor {
public class SqlEditorContributor extends TextEditorActionContributor{

	protected SourceViewer sqlViewer;

	/**
	 * RXgN^
	 * 
	 */
	public SqlEditorContributor() {
	}

	public void init(IActionBars bars, IWorkbenchPage page) {
		super.init(bars, page);
	}

	// j[\
	public void fillContextMenu(IMenuManager manager) {
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.UNDO));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.REDO));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.CUT));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.COPY));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.PASTE));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.DELETE));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.LINE_DEL));
		manager.add(new GlobalAction(sqlViewer, ITextOperationTarget.SELECT_ALL));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.ALL_EXECUTE));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.CURRENT_EXECUTE));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.SELECTED_EXECUTE));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.SCRIPT_EXECUTE));

		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.FORMAT));
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.UNFORMAT));
		manager.add(new Separator());
		manager.add(new GlobalAction(sqlViewer, ISQLOperationTarget.COMMENT));
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	// c[o[ǉꍇɃI[o[Ch
	public void contributeToToolBar(IToolBarManager manager) {
		super.contributeToToolBar(manager);

	}

//	public void contributeToMenu(IMenuManager menu) {
//		// Menuo[̍XV(Enable/Disable)̕@̂߁AȂ
//		// super.contributeToMenu(menu);
//		// IMenuManager editMenu
//		// =menu.findMenuUsingPath(IWorkbenchActionConstants.M_EDIT);
//		// if(editMenu!=null){
//		// editMenu.add(executeSQLAction);
//		// editMenu.add(executeCurrentSQLAction);
//		// editMenu.add(executeSelectedSQLAction);
//		// // deleteAction.refresh();
//		// // editMenu.add(new Separator());
//		// // editMenu.add(insertAction);
//		// // editMenu.add(deleteAction);
//		//		    		
//		// }
//	}

	public void setActivePage(IEditorPart target) {
		if (target != null && target instanceof SqlEditor) {
			sqlViewer = ((SqlEditor) target).sqlViewer;
		}
	}

//	private void makeAction(SqlEditor editor) {
//		sqlViewer = editor.sqlViewer;
//	}

	public void setActiveEditor(IEditorPart target) {
		super.setActiveEditor(target);
		if (target instanceof SqlEditor) {
			sqlViewer = ((SqlEditor) target).sqlViewer;
		}
	}

	void reflesh() {
	}

	public void dispose() {
		super.dispose();
	}


}
