/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ui.internal;

import java.io.Serializable;

import zigen.plugin.db.core.IDBConfig;

/**
 * TreeObjectNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/09 ZIGEN create.
 * 
 */
public class TreeLeaf implements INode, Serializable {

	protected int level = 0;

	protected String name;

	protected TreeNode parent;

	boolean isEnabled = true;

	public TreeLeaf() {
		this(null);
	}

	public TreeLeaf(String name) {
		this.name = name;
	}

	public boolean isEnabled() {
		return isEnabled;
	}

	public void setEnabled(boolean b) {
		this.isEnabled = b;
	}

	/**
	 * O̐ݒ
	 * 
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * O̎擾
	 * 
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * eIuWFNg̐ݒ
	 * 
	 * @param parent
	 */
	public void setParent(TreeNode parent) {
		this.parent = parent;
	}

	/**
	 * IuWFNg̎擾
	 * 
	 * @return
	 */
	public TreeNode getParent() {
		return parent;
	}

	/**
	 * toString\bh(LableProviderŎgpj
	 */
	public String toString() {
		return getName();
	}

	/**
	 * XL[}̎擾
	 * 
	 * @return
	 */
	public IDBConfig getDbConfig() {
		return getDbConfig(this);
	}

	/**
	 * XL[}̎擾
	 * 
	 * @return
	 */
	public DataBase getDataBase() {
		return getDataBase(this);
	}

	/**
	 * XL[}̎擾
	 * 
	 * @return
	 */
	public Schema getSchema() {
		return getSchema(this);
	}

	/**
	 * tH_̎擾
	 * 
	 * @return
	 */
	public Folder getFolder() {
		return getFolder(this);
	}

	/**
	 * e[u̎擾
	 * 
	 * @return
	 */
	public ITable getTable() {
		return getTable(this);
	}

	/**
	 * f[^x[X̎擾 ʂ̗vf܂ōċAIɌĂяo
	 * 
	 * @param leaf
	 * @return
	 */
	private DataBase getDataBase(TreeLeaf leaf) {
		if (leaf instanceof DataBase) {
			return (DataBase) leaf;
		} else {
			if (leaf.getParent() != null) {
				return getDataBase(leaf.getParent());
			} else {
				return null;
			}
		}
	}

	/**
	 * XL[}̎擾 ʂ̗vf܂ōċAIɌĂяo
	 * 
	 * @param leaf
	 * @return
	 */
	private Schema getSchema(TreeLeaf leaf) {
		if (leaf instanceof Schema) {
			return (Schema) leaf;
		} else {
			if (leaf.getParent() != null) {
				return getSchema(leaf.getParent());
			} else {
				return null;
			}
		}
	}

	/**
	 * tH_̎擾 ʂ̗vf܂ōċAIɌĂяo
	 * 
	 * @param leaf
	 * @return
	 */
	private Folder getFolder(TreeLeaf leaf) {
		if (leaf instanceof Folder) {
			return (Folder) leaf;
		} else {
			if (leaf.getParent() != null) {
				return getFolder(leaf.getParent());
			} else {
				return null;
			}
		}
	}

	/**
	 * e[u̎擾 ʂ̗vf܂ōċAIɌĂяo
	 * 
	 * @param leaf
	 * @return
	 */
	private ITable getTable(TreeLeaf leaf) {
		if (leaf instanceof ITable) {
			return (ITable) leaf;
		} else {
			if (leaf.getParent() != null) {
				return getTable(leaf.getParent());
			} else {
				return null;
			}
		}
	}

	/**
	 * IDBConfig̎擾 ʂ̗vf܂ōċAIɌĂяo
	 * 
	 * @param leaf
	 * @return
	 */
	protected IDBConfig getDbConfig(TreeLeaf leaf) {

		if (leaf instanceof DataBase) {
			return ((DataBase) leaf).getDbConfig();
		} else {

			if (leaf.getParent() != null) {
				return getDbConfig(leaf.getParent());
			} else {
				return null;
			}
		}
	}

	/**
	 * Adapter̎擾
	 */
	public Object getAdapter(Class key) {
		return null;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

}
