/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ui.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import kry.sql.format.SqlFormatRule;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.UpdateSQLFoldingJob;
import zigen.sql.parser.ASTVisitor2;
import zigen.sql.parser.INode;
import zigen.sql.parser.ISqlParser;
import zigen.sql.parser.Node;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTColumn;
import zigen.sql.parser.ast.ASTComma;
import zigen.sql.parser.ast.ASTFrom;
import zigen.sql.parser.ast.ASTFunction;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTRoot;
import zigen.sql.parser.ast.ASTSelect;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTWhere;
import zigen.sql.parser.exception.ParserException;

public class SQLOutinePage extends ContentOutlinePage implements ISelectionListener {

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (selection instanceof TextSelection) {
			TextSelection ts = (TextSelection) selection;

			if (currentSql.getBegin() <= ts.getOffset() && ts.getOffset() <= currentSql.getEnd()) {
				if (ts.getText().length() > 0) {
					if (visitor != null) {
						try {
							int searchOffset = ts.getOffset() - currentSql.getBegin();
							INode cNode = visitor.findNodeByOffset(searchOffset, ts.getLength());
							if (cNode != null) {
								StructuredSelection ss = new StructuredSelection(cNode);
								fTreeViewer.setSelection(ss, true);
								fTreeViewer.expandToLevel(ss, 1);
							}

						} catch (RuntimeException e) {
							e.printStackTrace();
						}
					}
				}
			} else {
				update();
			}
		}
	}

	SQLSourceViewer fSQLSourceViewer;

	SqlInput fSqlInput = new SqlInput();

	IDoubleClickListener doubleClickListener;

	SqlParser fSqlParser;

	ASTVisitor2 visitor;

	IDocument fDocument;

	TreeViewer fTreeViewer;

	IPreferenceStore ps;

	CurrentSql currentSql;

	public SQLOutinePage(SQLSourceViewer viewer) {
		this.fSQLSourceViewer = viewer;
		this.fDocument = viewer.getDocument();
		this.ps = DbPlugin.getDefault().getPreferenceStore();
	}

	public void createControl(Composite parent) {
		super.createControl(parent);
		fTreeViewer = getTreeViewer();
		fTreeViewer.setContentProvider(new TreeContentProvider());
		fTreeViewer.setLabelProvider(new TreeLabelProvider());
		doubleClickListener = new DoubleClickListener();
		fTreeViewer.addDoubleClickListener(doubleClickListener);
		fTreeViewer.setInput(fSqlInput);
		fTreeViewer.expandToLevel(2);
		update();

		getSite().getPage().addSelectionListener(this);

	}

	public void update() {
		int offset = fSQLSourceViewer.getTextWidget().getCaretOffset();

		String _temp = (currentSql != null) ? currentSql.getSql() : null;

		String demiliter = ps.getString(SQLEditorPreferencePage.P_SQL_DEMILITER);
		currentSql = new CurrentSql(fDocument, offset, demiliter);

		if (_temp == null || !_temp.equals(currentSql.getSql())) {
			UpdateOutlineJob job = new UpdateOutlineJob(currentSql);
			job.setPriority(UpdateSQLFoldingJob.LONG);
			job.setUser(false);
			job.schedule();
		}
	}

	private void revealRange(int offset, int length) {
		offset += currentSql.getBegin();
		fSQLSourceViewer.revealRange(offset, length);
		fSQLSourceViewer.setSelectedRange(offset, length);

	}

	/**
	 * ŏIm[hċAIɌ
	 * 
	 * @param node
	 * @return
	 */
	private INode getEndNode(INode node) {
		INode n = node.getLastChild();
		if (n == null) {
			return node;
		} else {
			return getEndNode(n);
		}
	}

	class SqlInput {
		INode documentElement;
	}

	class DoubleClickListener implements IDoubleClickListener {
		int offset = -1;

		int length = -1;

		private void calc(ASTColumn node) {
			offset = node.getOffset();
			length = node.getLength();
			if (node.hasAlias()) {
				length = node.getAliasOffset() + node.getAliasLength() - offset;
			}
		}

		private void calc(ASTParentheses node) {
			offset = node.getOffset();
			length = node.getEndOffset() + 1 - offset;
			if (node.hasAlias()) {
				length = node.getAliasOffset() + node.getAliasLength() - offset;
			}

		}

		private void calc(ASTSelectStatement node) {
			INode last = getEndNode(node);
			offset = node.getOffset();
			length = last.getOffset() + last.getLength() - offset;

			if (last instanceof ASTAlias) {
				ASTAlias as = (ASTAlias) last;
				if (as.hasAlias()) {
					length = as.getAliasOffset() + as.getAliasLength() - offset;
				}
			}

		}

		private void calc(ASTFunction node) {
			if (node.getChildrenSize() == 1 && node.getChild(0) instanceof ASTParentheses) {
				ASTParentheses p = (ASTParentheses) node.getChild(0);
				calc((ASTParentheses) node.getChild(0));
				// Functionoffset,length𔽉f
				offset = node.getOffset(); // offset́AFunction̂
				length += node.getLength(); // length́AFunctionZ

				if (node.hasAlias()) {
					length = node.getAliasOffset() + node.getAliasLength() - offset;
				}

			}
		}

		public void doubleClick(DoubleClickEvent event) {
			try {
				IStructuredSelection sel = (IStructuredSelection) event.getSelection();
				Object element = sel.getFirstElement();

				if (element instanceof ASTColumn) {
					calc((ASTColumn) element);

				} else if (element instanceof ASTParentheses) {
					calc(((ASTParentheses) element));

				} else if (element instanceof ASTSelectStatement) {
					calc((ASTSelectStatement) element);

				} else if (element instanceof ASTFunction) {
					calc((ASTFunction) element);

				} else if (element instanceof Node) {
					Node node = ((Node) element);
					offset = node.getOffset();
					length = node.getLength();
				}

				if (offset >= 0) {
					revealRange(offset, length);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

	class TreeLabelProvider extends LabelProvider {

		ImageCacher ic = ImageCacher.getInstance();

		public String getText(Object obj) {
//			if (obj instanceof ASTWhere) {
//				return getWhereString((ASTWhere) obj);
//			} else
//				
				if (obj instanceof Node) {
				return ((Node) obj).getName();
			}
			return obj.toString();
		}

		public Image getImage(Object obj) {
			// if(obj instanceof ASTTable){
			// return ic.getImage(DbPlugin.IMG_CODE_TABLE);
			// }else if(obj instanceof ASTColumn){
			// return ic.getImage(DbPlugin.IMG_CODE_COLUMN);
			// }
			return ic.getImage(DbPlugin.IMG_CODE_SQL);

			// String imageKey = ISharedImages.IMG_OBJ_ELEMENT;
			// return
			// PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
		}
//
//		 private String getWhereString(ASTWhere where) {
//			StringBuffer sb = new StringBuffer();
//		
//			int size = where.getChildrenSize();
//			List children = where.getChildren();
//			for (Iterator iter = children.iterator(); iter.hasNext();) {
//				INode node = (INode) iter.next();
//				
//				if(node instanceof ASTParentheses){
//					List list = p.getChildren();
//					int i = 0;
//					for (Iterator iter = list.iterator(); iter.hasNext();) {
//						INode nn = (INode) iter.next();
//						if (!(nn instanceof ASTComma)) {
//							if (i > 0) {
//								sb.append(", ");
//							}
//							sb.append(nn.getName());
//							i++;
//						}
//					}
//					sb.append(")");
//				}else if(node )
//			}
//
//			return sb.toString();
//		}

	}

	class TreeContentProvider implements ITreeContentProvider {

		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object inputElement) {
			return getChildren(fSqlInput.documentElement);
		}

		public Object getParent(Object element) {
			if (element instanceof Node) {
				return ((Node) element).getParent();
			}
			return null;
		}

		public Object[] getChildren(Object parentElement) {
			List result = new ArrayList();
			if (parentElement != null && parentElement instanceof Node) {
				Node node = (Node) parentElement;
				List list = node.getChildren();
				if (list != null) {
					if (node instanceof ASTFunction && list.size() == 10000) {	// ͂ʂȂ
						// Function̒ɂ()͕\Ȃ
						Object o = list.get(0);
						if (o instanceof ASTParentheses) {
							ASTParentheses p = (ASTParentheses) o;
							List list2 = p.getChildren();
							for (Iterator iter = list2.iterator(); iter.hasNext();) {
								Object obj = iter.next();
								if (!(obj instanceof ASTComma)) {
									result.add(obj);
								}
							}
						}

					} else {
						
						// ʏ̓J}͕\Ȃ
						for (Iterator iter = list.iterator(); iter.hasNext();) {
							Object obj = iter.next();
							if (!(obj instanceof ASTComma)) {
								result.add(obj);
							}
						}
						
					}
				}
			}
			return result.toArray(new Node[0]);
		}

		public boolean hasChildren(Object element) {
			if (element instanceof Node)
				return ((Node) element).getChildrenSize() > 0;
			return false;
		}
	}

	class ParseCancel extends ParserException {
		public ParseCancel(String message) {
			super(message, null, 0, 0);
		}
	}

	class SqlParserWithProgressMonitor extends SqlParser implements ISqlParser {
		IProgressMonitor monitor;

		public SqlParserWithProgressMonitor(IProgressMonitor monitor, String sql, SqlFormatRule rule) {
			super(sql, rule);
			// super.setTokenizer(new SqlTokenizerWithProgressMonitor(monitor,
			// sql, rule));
			this.monitor = monitor;
		}

		protected int nextToken() {
			if (monitor.isCanceled()) {
				throw new ParseCancel("SQL Parse cancel");
			} else {
				monitor.worked(1);
				return super.nextToken();
			}
		}
	}

	class UpdateOutlineJob extends AbstractJob {
		CurrentSql currentSql;

		public UpdateOutlineJob(CurrentSql currentSql) {
			super("Updating SQL Outline");
			this.currentSql = currentSql;
		}

		protected IStatus run(IProgressMonitor monitor) {
			zigen.sql.parser.ISqlParser parser = null;

			try {
				monitor.beginTask("Updating SQL Outline...", IProgressMonitor.UNKNOWN);

				if (monitor.isCanceled()) {
					return Status.CANCEL_STATUS;
				}
				monitor.subTask("Parsing SQL");

				String sql = currentSql.getSql();
				parser = new SqlParserWithProgressMonitor(monitor, sql, DbPlugin.getSqlFormatRult());
				final INode node = new ASTRoot();

				visitor = new ASTVisitor2();
				parser.parse(node);
				node.accept(visitor, null);

				monitor.subTask("Complete Parsed SQL " + currentSql);
				showResults(new Runnable() {
					public void run() {
						try {
							getTreeViewer().removeDoubleClickListener(doubleClickListener);
							fSqlInput.documentElement = node;
							fTreeViewer.refresh();
							//fTreeViewer.expandToLevel(2);
							
							int searchOffset = StringUtil.endWordPosition(currentSql.getOffsetSql());
							INode cNode = visitor.findNodeByOffset(searchOffset);
							fTreeViewer.expandToLevel(cNode, 1);
							//fTreeViewer.refresh(cNode);
							
							getTreeViewer().addDoubleClickListener(doubleClickListener);

						} catch (org.eclipse.swt.SWTException e) {
							;
						} catch (Exception e) {
							DbPlugin.log(e);
						}

					}
				});

				monitor.done();

			} catch (ParseCancel e) {
				return Status.CANCEL_STATUS;

			} catch (zigen.sql.parser.exception.ParserException e) {
				System.err.println(e.getMessage());

			} catch (Exception e) {
				showErrorMessage("The error occurred. ", e);
			} finally {
				if (parser != null)
					parser = null;
			}

			return Status.OK_STATUS;
		}
	}

}
