/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entityservice;

import java.util.Iterator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

import zigen.plugin.db.ext.s2jdbc.Activator;
import zigen.plugin.db.ext.s2jdbc.ICodeGenerator;
import zigen.plugin.db.ext.s2jdbc.entity.EntityGenerator;
import zigen.plugin.db.ext.s2jdbc.service.ServiceGenerator;
import zigen.plugin.db.ext.s2jdbc.ui.PackageSelectDialog;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public class GenerateEntityWithServiceAction implements IObjectActionDelegate {
	
	protected IAction action;
	
	protected IStructuredSelection selection;
	
	protected TreeView treeView;
	
	protected StructuredViewer structuredViewer;
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if (targetPart instanceof TreeView) {
			this.treeView = (TreeView) targetPart;
			this.structuredViewer = treeView.getTreeViewer();
		} else {
			throw new RuntimeException("Required TreeView"); //$NON-NLS-1$
		}
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
		this.action = action;
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
			this.action.setEnabled(true);
		} else {
			this.action.setEnabled(false);
			throw new RuntimeException("Required IStructuredSelection."); //$NON-NLS-1$
		}
	}
	
	protected void createFileAndOpen(PackageFragment pkg, String fileName, String contents) throws JavaModelException, PartInitException {
		pkg.createCompilationUnit(fileName, contents, true, new NullProgressMonitor());
		
		// String javaProjectName = pkg.getJavaProject().getElementName();
		String pkgName = pkg.getElementName().replace('.', '/');
		String srcPath = pkg.getPackageFragmentRoot().getPath().toString(); // łSRCȂ
		
		// Cӂ̃\[XtH_ꏊɕۑł悤ɏC
		IContainer container = pkg.getJavaProject().getProject().getParent();
		IPath path = new Path(srcPath + "/" + pkgName + "/" + fileName); //$NON-NLS-1$ //$NON-NLS-2$
		IFile file = container.getFile(path);
		
		IWorkbenchPage page = Activator.getDefault().getPage();
		
		IDE.openEditor(page, file);
	}
	
	// t@C̑݃`FbN
	protected boolean existFile(PackageFragment pkg, String checkFile) throws JavaModelException {
		IJavaElement[] javaElems = pkg.getChildren();
		for (int i = 0; i < javaElems.length; i++) {
			IJavaElement element = javaElems[i];
			if (element.getElementName().equals(checkFile)) {
				return true;
			}
		}
		return false;
	}
	
	public void run(IAction action) {
		Shell shell = Activator.getDefault().getShell();
		
		PackageSelectDialog dialog = new PackageSelectDialog(shell, getTitle(), getMessage());
		
		int res = dialog.open();
		if (res == PackageSelectDialog.OK) {
			PackageFragment pkg = dialog.getPackageFragment();
			String project = pkg.getJavaProject().getElementName();
			Activator.getDefault().setDefaultProject(project);
			for (Iterator iter = selection.iterator(); iter.hasNext();) {
				Object obj = iter.next();
				
				if (obj instanceof ITable) {
					ITable table = (ITable) obj;
					
					// Jvf̓ǂݍ
					loadColumnInfo(table);
					
					invoke(pkg, createEntityCreator(table, pkg.getElementName()));
					
					invoke(pkg, createServiceCreator(table, pkg.getElementName()));
					
				}
				

			}
		}
		
	}
	
	public void invoke(PackageFragment pkg, ICodeGenerator creator) {
		try {
			creator.execute();
			

			PackageFragmentRoot root = pkg.getPackageFragmentRoot();
			// pbP[W̐ݒ
			if (creator instanceof EntityGenerator) {
				create(pkg, "entity", creator);
			} else if (creator instanceof ServiceGenerator) {
				create(pkg, "service", creator);
				
			} else {
				;
			}
			

		} catch (Exception e) {
			Activator.getDefault().showErrorDialog(e);
		}
		
	}
	
	private void create(PackageFragment pkg, String subPackageName, ICodeGenerator creator) throws Exception {
		
		PackageFragmentRoot root = pkg.getPackageFragmentRoot();
		
		String pkgName = pkg.getElementName() + "." + subPackageName;
		
		root.createPackageFragment(pkgName, true, new NullProgressMonitor());
		root.getPackageFragment(pkgName);
		PackageFragment target = (PackageFragment) root.getPackageFragment(pkgName);
		String fileName = getEntityFileName(creator); //$NON-NLS-1$
		if (existFile(target, fileName)) {
			Shell shell = Activator.getDefault().getShell();
			MessageBox msg = new MessageBox(shell, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
			msg.setMessage(fileName + Messages.getString("GenerateAction.0")); //$NON-NLS-1$
			msg.setText(Messages.getString("GenerateAction.1")); //$NON-NLS-1$
			int res2 = msg.open();
			if (res2 == SWT.NO)
				return;
		}
		
		// pbP[W̐ݒ
		creator.setPackageString(pkgName);
		
		createFileAndOpen(target, fileName, creator.genaratedString());
		
	}
	
	
	protected void loadColumnInfo(ITable table) {
		// e[uvfWJς(Jvf擾ς݁j`FbN
		if (!table.isExpanded()) {
			// WJtOTrueɂ(e[uvfLbVj
			table.setExpanded(true);
			// e[uꗗ
			new ColumnSearchAction(structuredViewer, table).run();
		}
	}
	
	
	protected String getEntityFileName(ICodeGenerator creator) {
		return creator.getClassName() + ".java"; //$NON-NLS-1$
	}
	
	protected String getServiceFileName(ICodeGenerator creator) {
		return creator.getClassName() + "Service.java"; //$NON-NLS-1$
	}
	
	public String getTitle() {
		
		return Messages.getString("GenerateEntityWithServiceAction.Title"); //$NON-NLS-1$
		
	}
	
	public String getMessage() {
		return Messages.getString("PackageSelectDialog.Message"); //$NON-NLS-1$
	}
	
	public ICodeGenerator createEntityCreator(ITable table, String rootPackageName) {
		return new EntityGenerator(table);
	}
	
	public ICodeGenerator createServiceCreator(ITable table, String rootPackageName) {
		return new ServiceGenerator(table, rootPackageName);
	}
	

}
